/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.requests;

import com.oracle.bmc.osmanagement.model.RemovePackagesFromSoftwareSourceDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class RemovePackagesFromSoftwareSourceRequest
extends BmcRequest {
    private String softwareSourceId;
    private RemovePackagesFromSoftwareSourceDetails removePackagesFromSoftwareSourceDetails;
    private String opcRequestId;

    @ConstructorProperties(value={"softwareSourceId", "removePackagesFromSoftwareSourceDetails", "opcRequestId"})
    RemovePackagesFromSoftwareSourceRequest(String softwareSourceId, RemovePackagesFromSoftwareSourceDetails removePackagesFromSoftwareSourceDetails, String opcRequestId) {
        this.softwareSourceId = softwareSourceId;
        this.removePackagesFromSoftwareSourceDetails = removePackagesFromSoftwareSourceDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSoftwareSourceId() {
        return this.softwareSourceId;
    }

    public RemovePackagesFromSoftwareSourceDetails getRemovePackagesFromSoftwareSourceDetails() {
        return this.removePackagesFromSoftwareSourceDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder {
        private String softwareSourceId;
        private RemovePackagesFromSoftwareSourceDetails removePackagesFromSoftwareSourceDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RemovePackagesFromSoftwareSourceRequest o) {
            this.softwareSourceId(o.getSoftwareSourceId());
            this.removePackagesFromSoftwareSourceDetails(o.getRemovePackagesFromSoftwareSourceDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RemovePackagesFromSoftwareSourceRequest build() {
            RemovePackagesFromSoftwareSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder softwareSourceId(String softwareSourceId) {
            this.softwareSourceId = softwareSourceId;
            return this;
        }

        public Builder removePackagesFromSoftwareSourceDetails(RemovePackagesFromSoftwareSourceDetails removePackagesFromSoftwareSourceDetails) {
            this.removePackagesFromSoftwareSourceDetails = removePackagesFromSoftwareSourceDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public RemovePackagesFromSoftwareSourceRequest buildWithoutInvocationCallback() {
            return new RemovePackagesFromSoftwareSourceRequest(this.softwareSourceId, this.removePackagesFromSoftwareSourceDetails, this.opcRequestId);
        }

        public String toString() {
            return "RemovePackagesFromSoftwareSourceRequest.Builder(softwareSourceId=" + this.softwareSourceId + ", removePackagesFromSoftwareSourceDetails=" + this.removePackagesFromSoftwareSourceDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

