/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.osmanagement.model.ScheduledJob;
import com.oracle.bmc.osmanagement.requests.GetScheduledJobRequest;
import com.oracle.bmc.osmanagement.responses.GetScheduledJobResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetScheduledJobConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetScheduledJobConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetScheduledJobRequest interceptRequest(GetScheduledJobRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetScheduledJobRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getScheduledJobId(), (String)"scheduledJobId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20190801").path("scheduledJobs").path(HttpUtils.encodePathSegment((String)request.getScheduledJobId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetScheduledJobResponse> fromResponse() {
        Function<Response, GetScheduledJobResponse> transformer = new Function<Response, GetScheduledJobResponse>(){

            public GetScheduledJobResponse apply(Response rawResponse) {
                Optional retryAfterHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetScheduledJobResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ScheduledJob.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetScheduledJobResponse.Builder builder = GetScheduledJobResponse.builder();
                builder.scheduledJob((ScheduledJob)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((retryAfterHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"retry-after")).isPresent()) {
                    builder.retryAfter((Float)HeaderUtils.toValue((String)"retry-after", (String)((String)((List)retryAfterHeader.get()).get(0)), Float.class));
                }
                GetScheduledJobResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

