/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SummarizeExadataInsightResourceStatisticsRequest
extends BmcRequest<Void> {
    private String exadataInsightId;
    private String resourceType;
    private String resourceMetric;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private List<String> exadataType;
    private List<String> cdbName;
    private List<String> hostName;
    private Integer percentile;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getExadataInsightId() {
        return this.exadataInsightId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceMetric() {
        return this.resourceMetric;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public List<String> getExadataType() {
        return this.exadataType;
    }

    public List<String> getCdbName() {
        return this.cdbName;
    }

    public List<String> getHostName() {
        return this.hostName;
    }

    public Integer getPercentile() {
        return this.percentile;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().exadataInsightId(this.exadataInsightId).resourceType(this.resourceType).resourceMetric(this.resourceMetric).analysisTimeInterval(this.analysisTimeInterval).timeIntervalStart(this.timeIntervalStart).timeIntervalEnd(this.timeIntervalEnd).exadataType(this.exadataType).cdbName(this.cdbName).hostName(this.hostName).percentile(this.percentile).sortOrder(this.sortOrder).sortBy(this.sortBy).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",exadataInsightId=").append(String.valueOf(this.exadataInsightId));
        sb.append(",resourceType=").append(String.valueOf(this.resourceType));
        sb.append(",resourceMetric=").append(String.valueOf(this.resourceMetric));
        sb.append(",analysisTimeInterval=").append(String.valueOf(this.analysisTimeInterval));
        sb.append(",timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(",timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(",exadataType=").append(String.valueOf(this.exadataType));
        sb.append(",cdbName=").append(String.valueOf(this.cdbName));
        sb.append(",hostName=").append(String.valueOf(this.hostName));
        sb.append(",percentile=").append(String.valueOf(this.percentile));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeExadataInsightResourceStatisticsRequest)) {
            return false;
        }
        SummarizeExadataInsightResourceStatisticsRequest other = (SummarizeExadataInsightResourceStatisticsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.exadataInsightId, other.exadataInsightId) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.resourceMetric, other.resourceMetric) && Objects.equals(this.analysisTimeInterval, other.analysisTimeInterval) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.exadataType, other.exadataType) && Objects.equals(this.cdbName, other.cdbName) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.percentile, other.percentile) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exadataInsightId == null ? 43 : this.exadataInsightId.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceMetric == null ? 43 : this.resourceMetric.hashCode());
        result = result * 59 + (this.analysisTimeInterval == null ? 43 : this.analysisTimeInterval.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.exadataType == null ? 43 : this.exadataType.hashCode());
        result = result * 59 + (this.cdbName == null ? 43 : this.cdbName.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.percentile == null ? 43 : this.percentile.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeExadataInsightResourceStatisticsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String exadataInsightId = null;
        private String resourceType = null;
        private String resourceMetric = null;
        private String analysisTimeInterval = null;
        private Date timeIntervalStart = null;
        private Date timeIntervalEnd = null;
        private List<String> exadataType = null;
        private List<String> cdbName = null;
        private List<String> hostName = null;
        private Integer percentile = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder exadataInsightId(String exadataInsightId) {
            this.exadataInsightId = exadataInsightId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder resourceMetric(String resourceMetric) {
            this.resourceMetric = resourceMetric;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder exadataType(List<String> exadataType) {
            this.exadataType = exadataType;
            return this;
        }

        public Builder exadataType(String singularValue) {
            return this.exadataType(Arrays.asList(singularValue));
        }

        public Builder cdbName(List<String> cdbName) {
            this.cdbName = cdbName;
            return this;
        }

        public Builder cdbName(String singularValue) {
            return this.cdbName(Arrays.asList(singularValue));
        }

        public Builder hostName(List<String> hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder hostName(String singularValue) {
            return this.hostName(Arrays.asList(singularValue));
        }

        public Builder percentile(Integer percentile) {
            this.percentile = percentile;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeExadataInsightResourceStatisticsRequest o) {
            this.exadataInsightId(o.getExadataInsightId());
            this.resourceType(o.getResourceType());
            this.resourceMetric(o.getResourceMetric());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.exadataType(o.getExadataType());
            this.cdbName(o.getCdbName());
            this.hostName(o.getHostName());
            this.percentile(o.getPercentile());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeExadataInsightResourceStatisticsRequest build() {
            SummarizeExadataInsightResourceStatisticsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public SummarizeExadataInsightResourceStatisticsRequest buildWithoutInvocationCallback() {
            SummarizeExadataInsightResourceStatisticsRequest request = new SummarizeExadataInsightResourceStatisticsRequest();
            request.exadataInsightId = this.exadataInsightId;
            request.resourceType = this.resourceType;
            request.resourceMetric = this.resourceMetric;
            request.analysisTimeInterval = this.analysisTimeInterval;
            request.timeIntervalStart = this.timeIntervalStart;
            request.timeIntervalEnd = this.timeIntervalEnd;
            request.exadataType = this.exadataType;
            request.cdbName = this.cdbName;
            request.hostName = this.hostName;
            request.percentile = this.percentile;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        UtilizationPercent("utilizationPercent"),
        Usage("usage"),
        UsageChangePercent("usageChangePercent");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

