/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ListSqlSearchesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String sqlIdentifier;
    private String analysisTimeInterval;
    private Date timeIntervalStart;
    private Date timeIntervalEnd;
    private String page;
    private String opcRequestId;
    private List<String> definedTagEquals;
    private List<String> freeformTagEquals;
    private List<String> definedTagExists;
    private List<String> freeformTagExists;
    private Boolean compartmentIdInSubtree;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public String getAnalysisTimeInterval() {
        return this.analysisTimeInterval;
    }

    public Date getTimeIntervalStart() {
        return this.timeIntervalStart;
    }

    public Date getTimeIntervalEnd() {
        return this.timeIntervalEnd;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getDefinedTagEquals() {
        return this.definedTagEquals;
    }

    public List<String> getFreeformTagEquals() {
        return this.freeformTagEquals;
    }

    public List<String> getDefinedTagExists() {
        return this.definedTagExists;
    }

    public List<String> getFreeformTagExists() {
        return this.freeformTagExists;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).sqlIdentifier(this.sqlIdentifier).analysisTimeInterval(this.analysisTimeInterval).timeIntervalStart(this.timeIntervalStart).timeIntervalEnd(this.timeIntervalEnd).page(this.page).opcRequestId(this.opcRequestId).definedTagEquals(this.definedTagEquals).freeformTagEquals(this.freeformTagEquals).definedTagExists(this.definedTagExists).freeformTagExists(this.freeformTagExists).compartmentIdInSubtree(this.compartmentIdInSubtree);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(",analysisTimeInterval=").append(String.valueOf(this.analysisTimeInterval));
        sb.append(",timeIntervalStart=").append(String.valueOf(this.timeIntervalStart));
        sb.append(",timeIntervalEnd=").append(String.valueOf(this.timeIntervalEnd));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",definedTagEquals=").append(String.valueOf(this.definedTagEquals));
        sb.append(",freeformTagEquals=").append(String.valueOf(this.freeformTagEquals));
        sb.append(",definedTagExists=").append(String.valueOf(this.definedTagExists));
        sb.append(",freeformTagExists=").append(String.valueOf(this.freeformTagExists));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSqlSearchesRequest)) {
            return false;
        }
        ListSqlSearchesRequest other = (ListSqlSearchesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals(this.analysisTimeInterval, other.analysisTimeInterval) && Objects.equals(this.timeIntervalStart, other.timeIntervalStart) && Objects.equals(this.timeIntervalEnd, other.timeIntervalEnd) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.definedTagEquals, other.definedTagEquals) && Objects.equals(this.freeformTagEquals, other.freeformTagEquals) && Objects.equals(this.definedTagExists, other.definedTagExists) && Objects.equals(this.freeformTagExists, other.freeformTagExists) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.analysisTimeInterval == null ? 43 : this.analysisTimeInterval.hashCode());
        result = result * 59 + (this.timeIntervalStart == null ? 43 : this.timeIntervalStart.hashCode());
        result = result * 59 + (this.timeIntervalEnd == null ? 43 : this.timeIntervalEnd.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.definedTagEquals == null ? 43 : this.definedTagEquals.hashCode());
        result = result * 59 + (this.freeformTagEquals == null ? 43 : this.freeformTagEquals.hashCode());
        result = result * 59 + (this.definedTagExists == null ? 43 : this.definedTagExists.hashCode());
        result = result * 59 + (this.freeformTagExists == null ? 43 : this.freeformTagExists.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlSearchesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String sqlIdentifier = null;
        private String analysisTimeInterval = null;
        private Date timeIntervalStart = null;
        private Date timeIntervalEnd = null;
        private String page = null;
        private String opcRequestId = null;
        private List<String> definedTagEquals = null;
        private List<String> freeformTagEquals = null;
        private List<String> definedTagExists = null;
        private List<String> freeformTagExists = null;
        private Boolean compartmentIdInSubtree = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            return this;
        }

        public Builder analysisTimeInterval(String analysisTimeInterval) {
            this.analysisTimeInterval = analysisTimeInterval;
            return this;
        }

        public Builder timeIntervalStart(Date timeIntervalStart) {
            this.timeIntervalStart = timeIntervalStart;
            return this;
        }

        public Builder timeIntervalEnd(Date timeIntervalEnd) {
            this.timeIntervalEnd = timeIntervalEnd;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder definedTagEquals(List<String> definedTagEquals) {
            this.definedTagEquals = definedTagEquals;
            return this;
        }

        public Builder definedTagEquals(String singularValue) {
            return this.definedTagEquals(Arrays.asList(singularValue));
        }

        public Builder freeformTagEquals(List<String> freeformTagEquals) {
            this.freeformTagEquals = freeformTagEquals;
            return this;
        }

        public Builder freeformTagEquals(String singularValue) {
            return this.freeformTagEquals(Arrays.asList(singularValue));
        }

        public Builder definedTagExists(List<String> definedTagExists) {
            this.definedTagExists = definedTagExists;
            return this;
        }

        public Builder definedTagExists(String singularValue) {
            return this.definedTagExists(Arrays.asList(singularValue));
        }

        public Builder freeformTagExists(List<String> freeformTagExists) {
            this.freeformTagExists = freeformTagExists;
            return this;
        }

        public Builder freeformTagExists(String singularValue) {
            return this.freeformTagExists(Arrays.asList(singularValue));
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlSearchesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.sqlIdentifier(o.getSqlIdentifier());
            this.analysisTimeInterval(o.getAnalysisTimeInterval());
            this.timeIntervalStart(o.getTimeIntervalStart());
            this.timeIntervalEnd(o.getTimeIntervalEnd());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.definedTagEquals(o.getDefinedTagEquals());
            this.freeformTagEquals(o.getFreeformTagEquals());
            this.definedTagExists(o.getDefinedTagExists());
            this.freeformTagExists(o.getFreeformTagExists());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlSearchesRequest build() {
            ListSqlSearchesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSqlSearchesRequest buildWithoutInvocationCallback() {
            ListSqlSearchesRequest request = new ListSqlSearchesRequest();
            request.compartmentId = this.compartmentId;
            request.sqlIdentifier = this.sqlIdentifier;
            request.analysisTimeInterval = this.analysisTimeInterval;
            request.timeIntervalStart = this.timeIntervalStart;
            request.timeIntervalEnd = this.timeIntervalEnd;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.definedTagEquals = this.definedTagEquals;
            request.freeformTagEquals = this.freeformTagEquals;
            request.definedTagExists = this.definedTagExists;
            request.freeformTagExists = this.freeformTagExists;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            return request;
        }
    }
}

