/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ListSqlPlansRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String sqlIdentifier;
    private List<Long> planHash;
    private String databaseId;
    private String id;
    private String page;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public List<Long> getPlanHash() {
        return this.planHash;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getId() {
        return this.id;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).sqlIdentifier(this.sqlIdentifier).planHash(this.planHash).databaseId(this.databaseId).id(this.id).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(",planHash=").append(String.valueOf(this.planHash));
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSqlPlansRequest)) {
            return false;
        }
        ListSqlPlansRequest other = (ListSqlPlansRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals(this.planHash, other.planHash) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.id, other.id) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.planHash == null ? 43 : this.planHash.hashCode());
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSqlPlansRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String sqlIdentifier = null;
        private List<Long> planHash = null;
        private String databaseId = null;
        private String id = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            return this;
        }

        public Builder planHash(List<Long> planHash) {
            this.planHash = planHash;
            return this;
        }

        public Builder planHash(Long singularValue) {
            return this.planHash(Arrays.asList(singularValue));
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSqlPlansRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.sqlIdentifier(o.getSqlIdentifier());
            this.planHash(o.getPlanHash());
            this.databaseId(o.getDatabaseId());
            this.id(o.getId());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSqlPlansRequest build() {
            ListSqlPlansRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSqlPlansRequest buildWithoutInvocationCallback() {
            ListSqlPlansRequest request = new ListSqlPlansRequest();
            request.compartmentId = this.compartmentId;
            request.sqlIdentifier = this.sqlIdentifier;
            request.planHash = this.planHash;
            request.databaseId = this.databaseId;
            request.id = this.id;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

