/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ListImportableEnterpriseManagerEntitiesRequest
extends BmcRequest<Void> {
    private String enterpriseManagerBridgeId;
    private Integer limit;
    private String page;
    private List<String> enterpriseManagerEntityType;
    private String enterpriseManagerIdentifier;
    private String enterpriseManagerParentEntityIdentifier;
    private String opcRequestId;

    public String getEnterpriseManagerBridgeId() {
        return this.enterpriseManagerBridgeId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<String> getEnterpriseManagerEntityType() {
        return this.enterpriseManagerEntityType;
    }

    public String getEnterpriseManagerIdentifier() {
        return this.enterpriseManagerIdentifier;
    }

    public String getEnterpriseManagerParentEntityIdentifier() {
        return this.enterpriseManagerParentEntityIdentifier;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().enterpriseManagerBridgeId(this.enterpriseManagerBridgeId).limit(this.limit).page(this.page).enterpriseManagerEntityType(this.enterpriseManagerEntityType).enterpriseManagerIdentifier(this.enterpriseManagerIdentifier).enterpriseManagerParentEntityIdentifier(this.enterpriseManagerParentEntityIdentifier).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",enterpriseManagerBridgeId=").append(String.valueOf(this.enterpriseManagerBridgeId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",enterpriseManagerEntityType=").append(String.valueOf(this.enterpriseManagerEntityType));
        sb.append(",enterpriseManagerIdentifier=").append(String.valueOf(this.enterpriseManagerIdentifier));
        sb.append(",enterpriseManagerParentEntityIdentifier=").append(String.valueOf(this.enterpriseManagerParentEntityIdentifier));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListImportableEnterpriseManagerEntitiesRequest)) {
            return false;
        }
        ListImportableEnterpriseManagerEntitiesRequest other = (ListImportableEnterpriseManagerEntitiesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.enterpriseManagerBridgeId, other.enterpriseManagerBridgeId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.enterpriseManagerEntityType, other.enterpriseManagerEntityType) && Objects.equals(this.enterpriseManagerIdentifier, other.enterpriseManagerIdentifier) && Objects.equals(this.enterpriseManagerParentEntityIdentifier, other.enterpriseManagerParentEntityIdentifier) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.enterpriseManagerBridgeId == null ? 43 : this.enterpriseManagerBridgeId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.enterpriseManagerEntityType == null ? 43 : this.enterpriseManagerEntityType.hashCode());
        result = result * 59 + (this.enterpriseManagerIdentifier == null ? 43 : this.enterpriseManagerIdentifier.hashCode());
        result = result * 59 + (this.enterpriseManagerParentEntityIdentifier == null ? 43 : this.enterpriseManagerParentEntityIdentifier.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListImportableEnterpriseManagerEntitiesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String enterpriseManagerBridgeId = null;
        private Integer limit = null;
        private String page = null;
        private List<String> enterpriseManagerEntityType = null;
        private String enterpriseManagerIdentifier = null;
        private String enterpriseManagerParentEntityIdentifier = null;
        private String opcRequestId = null;

        public Builder enterpriseManagerBridgeId(String enterpriseManagerBridgeId) {
            this.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder enterpriseManagerEntityType(List<String> enterpriseManagerEntityType) {
            this.enterpriseManagerEntityType = enterpriseManagerEntityType;
            return this;
        }

        public Builder enterpriseManagerEntityType(String singularValue) {
            return this.enterpriseManagerEntityType(Arrays.asList(singularValue));
        }

        public Builder enterpriseManagerIdentifier(String enterpriseManagerIdentifier) {
            this.enterpriseManagerIdentifier = enterpriseManagerIdentifier;
            return this;
        }

        public Builder enterpriseManagerParentEntityIdentifier(String enterpriseManagerParentEntityIdentifier) {
            this.enterpriseManagerParentEntityIdentifier = enterpriseManagerParentEntityIdentifier;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListImportableEnterpriseManagerEntitiesRequest o) {
            this.enterpriseManagerBridgeId(o.getEnterpriseManagerBridgeId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.enterpriseManagerEntityType(o.getEnterpriseManagerEntityType());
            this.enterpriseManagerIdentifier(o.getEnterpriseManagerIdentifier());
            this.enterpriseManagerParentEntityIdentifier(o.getEnterpriseManagerParentEntityIdentifier());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListImportableEnterpriseManagerEntitiesRequest build() {
            ListImportableEnterpriseManagerEntitiesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListImportableEnterpriseManagerEntitiesRequest buildWithoutInvocationCallback() {
            ListImportableEnterpriseManagerEntitiesRequest request = new ListImportableEnterpriseManagerEntitiesRequest();
            request.enterpriseManagerBridgeId = this.enterpriseManagerBridgeId;
            request.limit = this.limit;
            request.page = this.page;
            request.enterpriseManagerEntityType = this.enterpriseManagerEntityType;
            request.enterpriseManagerIdentifier = this.enterpriseManagerIdentifier;
            request.enterpriseManagerParentEntityIdentifier = this.enterpriseManagerParentEntityIdentifier;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

