/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOperationsInsightsWarehouseRequest
extends BmcRequest<Void> {
    private String operationsInsightsWarehouseId;
    private String opcRequestId;

    public String getOperationsInsightsWarehouseId() {
        return this.operationsInsightsWarehouseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().operationsInsightsWarehouseId(this.operationsInsightsWarehouseId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",operationsInsightsWarehouseId=").append(String.valueOf(this.operationsInsightsWarehouseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOperationsInsightsWarehouseRequest)) {
            return false;
        }
        GetOperationsInsightsWarehouseRequest other = (GetOperationsInsightsWarehouseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.operationsInsightsWarehouseId, other.operationsInsightsWarehouseId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.operationsInsightsWarehouseId == null ? 43 : this.operationsInsightsWarehouseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOperationsInsightsWarehouseRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String operationsInsightsWarehouseId = null;
        private String opcRequestId = null;

        public Builder operationsInsightsWarehouseId(String operationsInsightsWarehouseId) {
            this.operationsInsightsWarehouseId = operationsInsightsWarehouseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOperationsInsightsWarehouseRequest o) {
            this.operationsInsightsWarehouseId(o.getOperationsInsightsWarehouseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOperationsInsightsWarehouseRequest build() {
            GetOperationsInsightsWarehouseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOperationsInsightsWarehouseRequest buildWithoutInvocationCallback() {
            GetOperationsInsightsWarehouseRequest request = new GetOperationsInsightsWarehouseRequest();
            request.operationsInsightsWarehouseId = this.operationsInsightsWarehouseId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

