/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetEnterpriseManagerBridgeRequest
extends BmcRequest<Void> {
    private String enterpriseManagerBridgeId;
    private String opcRequestId;

    public String getEnterpriseManagerBridgeId() {
        return this.enterpriseManagerBridgeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().enterpriseManagerBridgeId(this.enterpriseManagerBridgeId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",enterpriseManagerBridgeId=").append(String.valueOf(this.enterpriseManagerBridgeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEnterpriseManagerBridgeRequest)) {
            return false;
        }
        GetEnterpriseManagerBridgeRequest other = (GetEnterpriseManagerBridgeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.enterpriseManagerBridgeId, other.enterpriseManagerBridgeId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.enterpriseManagerBridgeId == null ? 43 : this.enterpriseManagerBridgeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEnterpriseManagerBridgeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String enterpriseManagerBridgeId = null;
        private String opcRequestId = null;

        public Builder enterpriseManagerBridgeId(String enterpriseManagerBridgeId) {
            this.enterpriseManagerBridgeId = enterpriseManagerBridgeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEnterpriseManagerBridgeRequest o) {
            this.enterpriseManagerBridgeId(o.getEnterpriseManagerBridgeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEnterpriseManagerBridgeRequest build() {
            GetEnterpriseManagerBridgeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetEnterpriseManagerBridgeRequest buildWithoutInvocationCallback() {
            GetEnterpriseManagerBridgeRequest request = new GetEnterpriseManagerBridgeRequest();
            request.enterpriseManagerBridgeId = this.enterpriseManagerBridgeId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

