/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VmClusterSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="vmclusterName")
    private final String vmclusterName;
    @JsonProperty(value="memoryAllocatedInGBs")
    private final Integer memoryAllocatedInGBs;
    @JsonProperty(value="cpuAllocated")
    private final Integer cpuAllocated;
    @JsonProperty(value="dbNodesCount")
    private final Integer dbNodesCount;

    @Deprecated
    @ConstructorProperties(value={"vmclusterName", "memoryAllocatedInGBs", "cpuAllocated", "dbNodesCount"})
    public VmClusterSummary(String vmclusterName, Integer memoryAllocatedInGBs, Integer cpuAllocated, Integer dbNodesCount) {
        this.vmclusterName = vmclusterName;
        this.memoryAllocatedInGBs = memoryAllocatedInGBs;
        this.cpuAllocated = cpuAllocated;
        this.dbNodesCount = dbNodesCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVmclusterName() {
        return this.vmclusterName;
    }

    public Integer getMemoryAllocatedInGBs() {
        return this.memoryAllocatedInGBs;
    }

    public Integer getCpuAllocated() {
        return this.cpuAllocated;
    }

    public Integer getDbNodesCount() {
        return this.dbNodesCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmClusterSummary(");
        sb.append("super=").append(super.toString());
        sb.append("vmclusterName=").append(String.valueOf(this.vmclusterName));
        sb.append(", memoryAllocatedInGBs=").append(String.valueOf(this.memoryAllocatedInGBs));
        sb.append(", cpuAllocated=").append(String.valueOf(this.cpuAllocated));
        sb.append(", dbNodesCount=").append(String.valueOf(this.dbNodesCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmClusterSummary)) {
            return false;
        }
        VmClusterSummary other = (VmClusterSummary)((Object)o);
        return Objects.equals(this.vmclusterName, other.vmclusterName) && Objects.equals(this.memoryAllocatedInGBs, other.memoryAllocatedInGBs) && Objects.equals(this.cpuAllocated, other.cpuAllocated) && Objects.equals(this.dbNodesCount, other.dbNodesCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.vmclusterName == null ? 43 : this.vmclusterName.hashCode());
        result = result * 59 + (this.memoryAllocatedInGBs == null ? 43 : this.memoryAllocatedInGBs.hashCode());
        result = result * 59 + (this.cpuAllocated == null ? 43 : this.cpuAllocated.hashCode());
        result = result * 59 + (this.dbNodesCount == null ? 43 : this.dbNodesCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vmclusterName")
        private String vmclusterName;
        @JsonProperty(value="memoryAllocatedInGBs")
        private Integer memoryAllocatedInGBs;
        @JsonProperty(value="cpuAllocated")
        private Integer cpuAllocated;
        @JsonProperty(value="dbNodesCount")
        private Integer dbNodesCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vmclusterName(String vmclusterName) {
            this.vmclusterName = vmclusterName;
            this.__explicitlySet__.add("vmclusterName");
            return this;
        }

        public Builder memoryAllocatedInGBs(Integer memoryAllocatedInGBs) {
            this.memoryAllocatedInGBs = memoryAllocatedInGBs;
            this.__explicitlySet__.add("memoryAllocatedInGBs");
            return this;
        }

        public Builder cpuAllocated(Integer cpuAllocated) {
            this.cpuAllocated = cpuAllocated;
            this.__explicitlySet__.add("cpuAllocated");
            return this;
        }

        public Builder dbNodesCount(Integer dbNodesCount) {
            this.dbNodesCount = dbNodesCount;
            this.__explicitlySet__.add("dbNodesCount");
            return this;
        }

        public VmClusterSummary build() {
            VmClusterSummary model = new VmClusterSummary(this.vmclusterName, this.memoryAllocatedInGBs, this.cpuAllocated, this.dbNodesCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmClusterSummary model) {
            if (model.wasPropertyExplicitlySet("vmclusterName")) {
                this.vmclusterName(model.getVmclusterName());
            }
            if (model.wasPropertyExplicitlySet("memoryAllocatedInGBs")) {
                this.memoryAllocatedInGBs(model.getMemoryAllocatedInGBs());
            }
            if (model.wasPropertyExplicitlySet("cpuAllocated")) {
                this.cpuAllocated(model.getCpuAllocated());
            }
            if (model.wasPropertyExplicitlySet("dbNodesCount")) {
                this.dbNodesCount(model.getDbNodesCount());
            }
            return this;
        }
    }
}

