/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SummaryStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="minimum")
    private final Double minimum;
    @JsonProperty(value="maximum")
    private final Double maximum;
    @JsonProperty(value="average")
    private final Double average;
    @JsonProperty(value="median")
    private final Double median;
    @JsonProperty(value="lowerQuartile")
    private final Double lowerQuartile;
    @JsonProperty(value="upperQuartile")
    private final Double upperQuartile;

    @Deprecated
    @ConstructorProperties(value={"minimum", "maximum", "average", "median", "lowerQuartile", "upperQuartile"})
    public SummaryStatistics(Double minimum, Double maximum, Double average, Double median, Double lowerQuartile, Double upperQuartile) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.average = average;
        this.median = median;
        this.lowerQuartile = lowerQuartile;
        this.upperQuartile = upperQuartile;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getAverage() {
        return this.average;
    }

    public Double getMedian() {
        return this.median;
    }

    public Double getLowerQuartile() {
        return this.lowerQuartile;
    }

    public Double getUpperQuartile() {
        return this.upperQuartile;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SummaryStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("minimum=").append(String.valueOf(this.minimum));
        sb.append(", maximum=").append(String.valueOf(this.maximum));
        sb.append(", average=").append(String.valueOf(this.average));
        sb.append(", median=").append(String.valueOf(this.median));
        sb.append(", lowerQuartile=").append(String.valueOf(this.lowerQuartile));
        sb.append(", upperQuartile=").append(String.valueOf(this.upperQuartile));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummaryStatistics)) {
            return false;
        }
        SummaryStatistics other = (SummaryStatistics)((Object)o);
        return Objects.equals(this.minimum, other.minimum) && Objects.equals(this.maximum, other.maximum) && Objects.equals(this.average, other.average) && Objects.equals(this.median, other.median) && Objects.equals(this.lowerQuartile, other.lowerQuartile) && Objects.equals(this.upperQuartile, other.upperQuartile) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.minimum == null ? 43 : this.minimum.hashCode());
        result = result * 59 + (this.maximum == null ? 43 : this.maximum.hashCode());
        result = result * 59 + (this.average == null ? 43 : this.average.hashCode());
        result = result * 59 + (this.median == null ? 43 : this.median.hashCode());
        result = result * 59 + (this.lowerQuartile == null ? 43 : this.lowerQuartile.hashCode());
        result = result * 59 + (this.upperQuartile == null ? 43 : this.upperQuartile.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="minimum")
        private Double minimum;
        @JsonProperty(value="maximum")
        private Double maximum;
        @JsonProperty(value="average")
        private Double average;
        @JsonProperty(value="median")
        private Double median;
        @JsonProperty(value="lowerQuartile")
        private Double lowerQuartile;
        @JsonProperty(value="upperQuartile")
        private Double upperQuartile;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder minimum(Double minimum) {
            this.minimum = minimum;
            this.__explicitlySet__.add("minimum");
            return this;
        }

        public Builder maximum(Double maximum) {
            this.maximum = maximum;
            this.__explicitlySet__.add("maximum");
            return this;
        }

        public Builder average(Double average) {
            this.average = average;
            this.__explicitlySet__.add("average");
            return this;
        }

        public Builder median(Double median) {
            this.median = median;
            this.__explicitlySet__.add("median");
            return this;
        }

        public Builder lowerQuartile(Double lowerQuartile) {
            this.lowerQuartile = lowerQuartile;
            this.__explicitlySet__.add("lowerQuartile");
            return this;
        }

        public Builder upperQuartile(Double upperQuartile) {
            this.upperQuartile = upperQuartile;
            this.__explicitlySet__.add("upperQuartile");
            return this;
        }

        public SummaryStatistics build() {
            SummaryStatistics model = new SummaryStatistics(this.minimum, this.maximum, this.average, this.median, this.lowerQuartile, this.upperQuartile);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SummaryStatistics model) {
            if (model.wasPropertyExplicitlySet("minimum")) {
                this.minimum(model.getMinimum());
            }
            if (model.wasPropertyExplicitlySet("maximum")) {
                this.maximum(model.getMaximum());
            }
            if (model.wasPropertyExplicitlySet("average")) {
                this.average(model.getAverage());
            }
            if (model.wasPropertyExplicitlySet("median")) {
                this.median(model.getMedian());
            }
            if (model.wasPropertyExplicitlySet("lowerQuartile")) {
                this.lowerQuartile(model.getLowerQuartile());
            }
            if (model.wasPropertyExplicitlySet("upperQuartile")) {
                this.upperQuartile(model.getUpperQuartile());
            }
            return this;
        }
    }
}

