/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum StorageServer implements BmcEnum
{
    Storage("STORAGE"),
    Iops("IOPS"),
    Throughput("THROUGHPUT");

    private final String value;
    private static Map<String, StorageServer> map;

    private StorageServer(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static StorageServer create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid StorageServer: " + key);
    }

    static {
        map = new HashMap<String, StorageServer>();
        for (StorageServer v : StorageServer.values()) {
            map.put(v.getValue(), v);
        }
    }
}

