/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlStats
extends ExplicitlySetBmcModel {
    @JsonProperty(value="sqlIdentifier")
    private final String sqlIdentifier;
    @JsonProperty(value="planHashValue")
    private final Long planHashValue;
    @JsonProperty(value="timeCollected")
    private final Date timeCollected;
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="lastActiveTime")
    private final String lastActiveTime;
    @JsonProperty(value="parseCalls")
    private final Long parseCalls;
    @JsonProperty(value="diskReads")
    private final Long diskReads;
    @JsonProperty(value="directReads")
    private final Long directReads;
    @JsonProperty(value="directWrites")
    private final Long directWrites;
    @JsonProperty(value="bufferGets")
    private final Long bufferGets;
    @JsonProperty(value="rowsProcessed")
    private final Long rowsProcessed;
    @JsonProperty(value="serializableAborts")
    private final Long serializableAborts;
    @JsonProperty(value="fetches")
    private final Long fetches;
    @JsonProperty(value="executions")
    private final Long executions;
    @JsonProperty(value="avoidedExecutions")
    private final Long avoidedExecutions;
    @JsonProperty(value="endOfFetchCount")
    private final Long endOfFetchCount;
    @JsonProperty(value="loads")
    private final Long loads;
    @JsonProperty(value="versionCount")
    private final Long versionCount;
    @JsonProperty(value="invalidations")
    private final Long invalidations;
    @JsonProperty(value="obsoleteCount")
    private final Long obsoleteCount;
    @JsonProperty(value="pxServersExecutions")
    private final Long pxServersExecutions;
    @JsonProperty(value="cpuTimeInUs")
    private final Long cpuTimeInUs;
    @JsonProperty(value="elapsedTimeInUs")
    private final Long elapsedTimeInUs;
    @JsonProperty(value="avgHardParseTimeInUs")
    private final Long avgHardParseTimeInUs;
    @JsonProperty(value="concurrencyWaitTimeInUs")
    private final Long concurrencyWaitTimeInUs;
    @JsonProperty(value="applicationWaitTimeInUs")
    private final Long applicationWaitTimeInUs;
    @JsonProperty(value="clusterWaitTimeInUs")
    private final Long clusterWaitTimeInUs;
    @JsonProperty(value="userIoWaitTimeInUs")
    private final Long userIoWaitTimeInUs;
    @JsonProperty(value="plsqlExecTimeInUs")
    private final Long plsqlExecTimeInUs;
    @JsonProperty(value="javaExecTimeInUs")
    private final Long javaExecTimeInUs;
    @JsonProperty(value="sorts")
    private final Long sorts;
    @JsonProperty(value="sharableMem")
    private final Long sharableMem;
    @JsonProperty(value="totalSharableMem")
    private final Long totalSharableMem;
    @JsonProperty(value="typeCheckMem")
    private final Long typeCheckMem;
    @JsonProperty(value="ioCellOffloadEligibleBytes")
    private final Long ioCellOffloadEligibleBytes;
    @JsonProperty(value="ioInterconnectBytes")
    private final Long ioInterconnectBytes;
    @JsonProperty(value="physicalReadRequests")
    private final Long physicalReadRequests;
    @JsonProperty(value="physicalReadBytes")
    private final Long physicalReadBytes;
    @JsonProperty(value="physicalWriteRequests")
    private final Long physicalWriteRequests;
    @JsonProperty(value="physicalWriteBytes")
    private final Long physicalWriteBytes;
    @JsonProperty(value="exactMatchingSignature")
    private final String exactMatchingSignature;
    @JsonProperty(value="forceMatchingSignature")
    private final String forceMatchingSignature;
    @JsonProperty(value="ioCellUncompressedBytes")
    private final Long ioCellUncompressedBytes;
    @JsonProperty(value="ioCellOffloadReturnedBytes")
    private final Long ioCellOffloadReturnedBytes;
    @JsonProperty(value="childNumber")
    private final Long childNumber;
    @JsonProperty(value="commandType")
    private final Long commandType;
    @JsonProperty(value="usersOpening")
    private final Long usersOpening;
    @JsonProperty(value="usersExecuting")
    private final Long usersExecuting;
    @JsonProperty(value="optimizerCost")
    private final Long optimizerCost;
    @JsonProperty(value="fullPlanHashValue")
    private final String fullPlanHashValue;
    @JsonProperty(value="module")
    private final String module;
    @JsonProperty(value="service")
    private final String service;
    @JsonProperty(value="action")
    private final String action;
    @JsonProperty(value="sqlProfile")
    private final String sqlProfile;
    @JsonProperty(value="sqlPatch")
    private final String sqlPatch;
    @JsonProperty(value="sqlPlanBaseline")
    private final String sqlPlanBaseline;
    @JsonProperty(value="deltaExecutionCount")
    private final Long deltaExecutionCount;
    @JsonProperty(value="deltaCpuTime")
    private final Long deltaCpuTime;
    @JsonProperty(value="deltaIoBytes")
    private final Long deltaIoBytes;
    @JsonProperty(value="deltaCpuRank")
    private final Long deltaCpuRank;
    @JsonProperty(value="deltaExecsRank")
    private final Long deltaExecsRank;
    @JsonProperty(value="sharableMemRank")
    private final Long sharableMemRank;
    @JsonProperty(value="deltaIoRank")
    private final Long deltaIoRank;
    @JsonProperty(value="harmonicSum")
    private final Long harmonicSum;
    @JsonProperty(value="wtHarmonicSum")
    private final Long wtHarmonicSum;
    @JsonProperty(value="totalSqlCount")
    private final Long totalSqlCount;

    @Deprecated
    @ConstructorProperties(value={"sqlIdentifier", "planHashValue", "timeCollected", "instanceName", "lastActiveTime", "parseCalls", "diskReads", "directReads", "directWrites", "bufferGets", "rowsProcessed", "serializableAborts", "fetches", "executions", "avoidedExecutions", "endOfFetchCount", "loads", "versionCount", "invalidations", "obsoleteCount", "pxServersExecutions", "cpuTimeInUs", "elapsedTimeInUs", "avgHardParseTimeInUs", "concurrencyWaitTimeInUs", "applicationWaitTimeInUs", "clusterWaitTimeInUs", "userIoWaitTimeInUs", "plsqlExecTimeInUs", "javaExecTimeInUs", "sorts", "sharableMem", "totalSharableMem", "typeCheckMem", "ioCellOffloadEligibleBytes", "ioInterconnectBytes", "physicalReadRequests", "physicalReadBytes", "physicalWriteRequests", "physicalWriteBytes", "exactMatchingSignature", "forceMatchingSignature", "ioCellUncompressedBytes", "ioCellOffloadReturnedBytes", "childNumber", "commandType", "usersOpening", "usersExecuting", "optimizerCost", "fullPlanHashValue", "module", "service", "action", "sqlProfile", "sqlPatch", "sqlPlanBaseline", "deltaExecutionCount", "deltaCpuTime", "deltaIoBytes", "deltaCpuRank", "deltaExecsRank", "sharableMemRank", "deltaIoRank", "harmonicSum", "wtHarmonicSum", "totalSqlCount"})
    public SqlStats(String sqlIdentifier, Long planHashValue, Date timeCollected, String instanceName, String lastActiveTime, Long parseCalls, Long diskReads, Long directReads, Long directWrites, Long bufferGets, Long rowsProcessed, Long serializableAborts, Long fetches, Long executions, Long avoidedExecutions, Long endOfFetchCount, Long loads, Long versionCount, Long invalidations, Long obsoleteCount, Long pxServersExecutions, Long cpuTimeInUs, Long elapsedTimeInUs, Long avgHardParseTimeInUs, Long concurrencyWaitTimeInUs, Long applicationWaitTimeInUs, Long clusterWaitTimeInUs, Long userIoWaitTimeInUs, Long plsqlExecTimeInUs, Long javaExecTimeInUs, Long sorts, Long sharableMem, Long totalSharableMem, Long typeCheckMem, Long ioCellOffloadEligibleBytes, Long ioInterconnectBytes, Long physicalReadRequests, Long physicalReadBytes, Long physicalWriteRequests, Long physicalWriteBytes, String exactMatchingSignature, String forceMatchingSignature, Long ioCellUncompressedBytes, Long ioCellOffloadReturnedBytes, Long childNumber, Long commandType, Long usersOpening, Long usersExecuting, Long optimizerCost, String fullPlanHashValue, String module, String service, String action, String sqlProfile, String sqlPatch, String sqlPlanBaseline, Long deltaExecutionCount, Long deltaCpuTime, Long deltaIoBytes, Long deltaCpuRank, Long deltaExecsRank, Long sharableMemRank, Long deltaIoRank, Long harmonicSum, Long wtHarmonicSum, Long totalSqlCount) {
        this.sqlIdentifier = sqlIdentifier;
        this.planHashValue = planHashValue;
        this.timeCollected = timeCollected;
        this.instanceName = instanceName;
        this.lastActiveTime = lastActiveTime;
        this.parseCalls = parseCalls;
        this.diskReads = diskReads;
        this.directReads = directReads;
        this.directWrites = directWrites;
        this.bufferGets = bufferGets;
        this.rowsProcessed = rowsProcessed;
        this.serializableAborts = serializableAborts;
        this.fetches = fetches;
        this.executions = executions;
        this.avoidedExecutions = avoidedExecutions;
        this.endOfFetchCount = endOfFetchCount;
        this.loads = loads;
        this.versionCount = versionCount;
        this.invalidations = invalidations;
        this.obsoleteCount = obsoleteCount;
        this.pxServersExecutions = pxServersExecutions;
        this.cpuTimeInUs = cpuTimeInUs;
        this.elapsedTimeInUs = elapsedTimeInUs;
        this.avgHardParseTimeInUs = avgHardParseTimeInUs;
        this.concurrencyWaitTimeInUs = concurrencyWaitTimeInUs;
        this.applicationWaitTimeInUs = applicationWaitTimeInUs;
        this.clusterWaitTimeInUs = clusterWaitTimeInUs;
        this.userIoWaitTimeInUs = userIoWaitTimeInUs;
        this.plsqlExecTimeInUs = plsqlExecTimeInUs;
        this.javaExecTimeInUs = javaExecTimeInUs;
        this.sorts = sorts;
        this.sharableMem = sharableMem;
        this.totalSharableMem = totalSharableMem;
        this.typeCheckMem = typeCheckMem;
        this.ioCellOffloadEligibleBytes = ioCellOffloadEligibleBytes;
        this.ioInterconnectBytes = ioInterconnectBytes;
        this.physicalReadRequests = physicalReadRequests;
        this.physicalReadBytes = physicalReadBytes;
        this.physicalWriteRequests = physicalWriteRequests;
        this.physicalWriteBytes = physicalWriteBytes;
        this.exactMatchingSignature = exactMatchingSignature;
        this.forceMatchingSignature = forceMatchingSignature;
        this.ioCellUncompressedBytes = ioCellUncompressedBytes;
        this.ioCellOffloadReturnedBytes = ioCellOffloadReturnedBytes;
        this.childNumber = childNumber;
        this.commandType = commandType;
        this.usersOpening = usersOpening;
        this.usersExecuting = usersExecuting;
        this.optimizerCost = optimizerCost;
        this.fullPlanHashValue = fullPlanHashValue;
        this.module = module;
        this.service = service;
        this.action = action;
        this.sqlProfile = sqlProfile;
        this.sqlPatch = sqlPatch;
        this.sqlPlanBaseline = sqlPlanBaseline;
        this.deltaExecutionCount = deltaExecutionCount;
        this.deltaCpuTime = deltaCpuTime;
        this.deltaIoBytes = deltaIoBytes;
        this.deltaCpuRank = deltaCpuRank;
        this.deltaExecsRank = deltaExecsRank;
        this.sharableMemRank = sharableMemRank;
        this.deltaIoRank = deltaIoRank;
        this.harmonicSum = harmonicSum;
        this.wtHarmonicSum = wtHarmonicSum;
        this.totalSqlCount = totalSqlCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    public Long getPlanHashValue() {
        return this.planHashValue;
    }

    public Date getTimeCollected() {
        return this.timeCollected;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getLastActiveTime() {
        return this.lastActiveTime;
    }

    public Long getParseCalls() {
        return this.parseCalls;
    }

    public Long getDiskReads() {
        return this.diskReads;
    }

    public Long getDirectReads() {
        return this.directReads;
    }

    public Long getDirectWrites() {
        return this.directWrites;
    }

    public Long getBufferGets() {
        return this.bufferGets;
    }

    public Long getRowsProcessed() {
        return this.rowsProcessed;
    }

    public Long getSerializableAborts() {
        return this.serializableAborts;
    }

    public Long getFetches() {
        return this.fetches;
    }

    public Long getExecutions() {
        return this.executions;
    }

    public Long getAvoidedExecutions() {
        return this.avoidedExecutions;
    }

    public Long getEndOfFetchCount() {
        return this.endOfFetchCount;
    }

    public Long getLoads() {
        return this.loads;
    }

    public Long getVersionCount() {
        return this.versionCount;
    }

    public Long getInvalidations() {
        return this.invalidations;
    }

    public Long getObsoleteCount() {
        return this.obsoleteCount;
    }

    public Long getPxServersExecutions() {
        return this.pxServersExecutions;
    }

    public Long getCpuTimeInUs() {
        return this.cpuTimeInUs;
    }

    public Long getElapsedTimeInUs() {
        return this.elapsedTimeInUs;
    }

    public Long getAvgHardParseTimeInUs() {
        return this.avgHardParseTimeInUs;
    }

    public Long getConcurrencyWaitTimeInUs() {
        return this.concurrencyWaitTimeInUs;
    }

    public Long getApplicationWaitTimeInUs() {
        return this.applicationWaitTimeInUs;
    }

    public Long getClusterWaitTimeInUs() {
        return this.clusterWaitTimeInUs;
    }

    public Long getUserIoWaitTimeInUs() {
        return this.userIoWaitTimeInUs;
    }

    public Long getPlsqlExecTimeInUs() {
        return this.plsqlExecTimeInUs;
    }

    public Long getJavaExecTimeInUs() {
        return this.javaExecTimeInUs;
    }

    public Long getSorts() {
        return this.sorts;
    }

    public Long getSharableMem() {
        return this.sharableMem;
    }

    public Long getTotalSharableMem() {
        return this.totalSharableMem;
    }

    public Long getTypeCheckMem() {
        return this.typeCheckMem;
    }

    public Long getIoCellOffloadEligibleBytes() {
        return this.ioCellOffloadEligibleBytes;
    }

    public Long getIoInterconnectBytes() {
        return this.ioInterconnectBytes;
    }

    public Long getPhysicalReadRequests() {
        return this.physicalReadRequests;
    }

    public Long getPhysicalReadBytes() {
        return this.physicalReadBytes;
    }

    public Long getPhysicalWriteRequests() {
        return this.physicalWriteRequests;
    }

    public Long getPhysicalWriteBytes() {
        return this.physicalWriteBytes;
    }

    public String getExactMatchingSignature() {
        return this.exactMatchingSignature;
    }

    public String getForceMatchingSignature() {
        return this.forceMatchingSignature;
    }

    public Long getIoCellUncompressedBytes() {
        return this.ioCellUncompressedBytes;
    }

    public Long getIoCellOffloadReturnedBytes() {
        return this.ioCellOffloadReturnedBytes;
    }

    public Long getChildNumber() {
        return this.childNumber;
    }

    public Long getCommandType() {
        return this.commandType;
    }

    public Long getUsersOpening() {
        return this.usersOpening;
    }

    public Long getUsersExecuting() {
        return this.usersExecuting;
    }

    public Long getOptimizerCost() {
        return this.optimizerCost;
    }

    public String getFullPlanHashValue() {
        return this.fullPlanHashValue;
    }

    public String getModule() {
        return this.module;
    }

    public String getService() {
        return this.service;
    }

    public String getAction() {
        return this.action;
    }

    public String getSqlProfile() {
        return this.sqlProfile;
    }

    public String getSqlPatch() {
        return this.sqlPatch;
    }

    public String getSqlPlanBaseline() {
        return this.sqlPlanBaseline;
    }

    public Long getDeltaExecutionCount() {
        return this.deltaExecutionCount;
    }

    public Long getDeltaCpuTime() {
        return this.deltaCpuTime;
    }

    public Long getDeltaIoBytes() {
        return this.deltaIoBytes;
    }

    public Long getDeltaCpuRank() {
        return this.deltaCpuRank;
    }

    public Long getDeltaExecsRank() {
        return this.deltaExecsRank;
    }

    public Long getSharableMemRank() {
        return this.sharableMemRank;
    }

    public Long getDeltaIoRank() {
        return this.deltaIoRank;
    }

    public Long getHarmonicSum() {
        return this.harmonicSum;
    }

    public Long getWtHarmonicSum() {
        return this.wtHarmonicSum;
    }

    public Long getTotalSqlCount() {
        return this.totalSqlCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlStats(");
        sb.append("super=").append(super.toString());
        sb.append("sqlIdentifier=").append(String.valueOf(this.sqlIdentifier));
        sb.append(", planHashValue=").append(String.valueOf(this.planHashValue));
        sb.append(", timeCollected=").append(String.valueOf(this.timeCollected));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", lastActiveTime=").append(String.valueOf(this.lastActiveTime));
        sb.append(", parseCalls=").append(String.valueOf(this.parseCalls));
        sb.append(", diskReads=").append(String.valueOf(this.diskReads));
        sb.append(", directReads=").append(String.valueOf(this.directReads));
        sb.append(", directWrites=").append(String.valueOf(this.directWrites));
        sb.append(", bufferGets=").append(String.valueOf(this.bufferGets));
        sb.append(", rowsProcessed=").append(String.valueOf(this.rowsProcessed));
        sb.append(", serializableAborts=").append(String.valueOf(this.serializableAborts));
        sb.append(", fetches=").append(String.valueOf(this.fetches));
        sb.append(", executions=").append(String.valueOf(this.executions));
        sb.append(", avoidedExecutions=").append(String.valueOf(this.avoidedExecutions));
        sb.append(", endOfFetchCount=").append(String.valueOf(this.endOfFetchCount));
        sb.append(", loads=").append(String.valueOf(this.loads));
        sb.append(", versionCount=").append(String.valueOf(this.versionCount));
        sb.append(", invalidations=").append(String.valueOf(this.invalidations));
        sb.append(", obsoleteCount=").append(String.valueOf(this.obsoleteCount));
        sb.append(", pxServersExecutions=").append(String.valueOf(this.pxServersExecutions));
        sb.append(", cpuTimeInUs=").append(String.valueOf(this.cpuTimeInUs));
        sb.append(", elapsedTimeInUs=").append(String.valueOf(this.elapsedTimeInUs));
        sb.append(", avgHardParseTimeInUs=").append(String.valueOf(this.avgHardParseTimeInUs));
        sb.append(", concurrencyWaitTimeInUs=").append(String.valueOf(this.concurrencyWaitTimeInUs));
        sb.append(", applicationWaitTimeInUs=").append(String.valueOf(this.applicationWaitTimeInUs));
        sb.append(", clusterWaitTimeInUs=").append(String.valueOf(this.clusterWaitTimeInUs));
        sb.append(", userIoWaitTimeInUs=").append(String.valueOf(this.userIoWaitTimeInUs));
        sb.append(", plsqlExecTimeInUs=").append(String.valueOf(this.plsqlExecTimeInUs));
        sb.append(", javaExecTimeInUs=").append(String.valueOf(this.javaExecTimeInUs));
        sb.append(", sorts=").append(String.valueOf(this.sorts));
        sb.append(", sharableMem=").append(String.valueOf(this.sharableMem));
        sb.append(", totalSharableMem=").append(String.valueOf(this.totalSharableMem));
        sb.append(", typeCheckMem=").append(String.valueOf(this.typeCheckMem));
        sb.append(", ioCellOffloadEligibleBytes=").append(String.valueOf(this.ioCellOffloadEligibleBytes));
        sb.append(", ioInterconnectBytes=").append(String.valueOf(this.ioInterconnectBytes));
        sb.append(", physicalReadRequests=").append(String.valueOf(this.physicalReadRequests));
        sb.append(", physicalReadBytes=").append(String.valueOf(this.physicalReadBytes));
        sb.append(", physicalWriteRequests=").append(String.valueOf(this.physicalWriteRequests));
        sb.append(", physicalWriteBytes=").append(String.valueOf(this.physicalWriteBytes));
        sb.append(", exactMatchingSignature=").append(String.valueOf(this.exactMatchingSignature));
        sb.append(", forceMatchingSignature=").append(String.valueOf(this.forceMatchingSignature));
        sb.append(", ioCellUncompressedBytes=").append(String.valueOf(this.ioCellUncompressedBytes));
        sb.append(", ioCellOffloadReturnedBytes=").append(String.valueOf(this.ioCellOffloadReturnedBytes));
        sb.append(", childNumber=").append(String.valueOf(this.childNumber));
        sb.append(", commandType=").append(String.valueOf(this.commandType));
        sb.append(", usersOpening=").append(String.valueOf(this.usersOpening));
        sb.append(", usersExecuting=").append(String.valueOf(this.usersExecuting));
        sb.append(", optimizerCost=").append(String.valueOf(this.optimizerCost));
        sb.append(", fullPlanHashValue=").append(String.valueOf(this.fullPlanHashValue));
        sb.append(", module=").append(String.valueOf(this.module));
        sb.append(", service=").append(String.valueOf(this.service));
        sb.append(", action=").append(String.valueOf(this.action));
        sb.append(", sqlProfile=").append(String.valueOf(this.sqlProfile));
        sb.append(", sqlPatch=").append(String.valueOf(this.sqlPatch));
        sb.append(", sqlPlanBaseline=").append(String.valueOf(this.sqlPlanBaseline));
        sb.append(", deltaExecutionCount=").append(String.valueOf(this.deltaExecutionCount));
        sb.append(", deltaCpuTime=").append(String.valueOf(this.deltaCpuTime));
        sb.append(", deltaIoBytes=").append(String.valueOf(this.deltaIoBytes));
        sb.append(", deltaCpuRank=").append(String.valueOf(this.deltaCpuRank));
        sb.append(", deltaExecsRank=").append(String.valueOf(this.deltaExecsRank));
        sb.append(", sharableMemRank=").append(String.valueOf(this.sharableMemRank));
        sb.append(", deltaIoRank=").append(String.valueOf(this.deltaIoRank));
        sb.append(", harmonicSum=").append(String.valueOf(this.harmonicSum));
        sb.append(", wtHarmonicSum=").append(String.valueOf(this.wtHarmonicSum));
        sb.append(", totalSqlCount=").append(String.valueOf(this.totalSqlCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlStats)) {
            return false;
        }
        SqlStats other = (SqlStats)((Object)o);
        return Objects.equals(this.sqlIdentifier, other.sqlIdentifier) && Objects.equals(this.planHashValue, other.planHashValue) && Objects.equals(this.timeCollected, other.timeCollected) && Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.lastActiveTime, other.lastActiveTime) && Objects.equals(this.parseCalls, other.parseCalls) && Objects.equals(this.diskReads, other.diskReads) && Objects.equals(this.directReads, other.directReads) && Objects.equals(this.directWrites, other.directWrites) && Objects.equals(this.bufferGets, other.bufferGets) && Objects.equals(this.rowsProcessed, other.rowsProcessed) && Objects.equals(this.serializableAborts, other.serializableAborts) && Objects.equals(this.fetches, other.fetches) && Objects.equals(this.executions, other.executions) && Objects.equals(this.avoidedExecutions, other.avoidedExecutions) && Objects.equals(this.endOfFetchCount, other.endOfFetchCount) && Objects.equals(this.loads, other.loads) && Objects.equals(this.versionCount, other.versionCount) && Objects.equals(this.invalidations, other.invalidations) && Objects.equals(this.obsoleteCount, other.obsoleteCount) && Objects.equals(this.pxServersExecutions, other.pxServersExecutions) && Objects.equals(this.cpuTimeInUs, other.cpuTimeInUs) && Objects.equals(this.elapsedTimeInUs, other.elapsedTimeInUs) && Objects.equals(this.avgHardParseTimeInUs, other.avgHardParseTimeInUs) && Objects.equals(this.concurrencyWaitTimeInUs, other.concurrencyWaitTimeInUs) && Objects.equals(this.applicationWaitTimeInUs, other.applicationWaitTimeInUs) && Objects.equals(this.clusterWaitTimeInUs, other.clusterWaitTimeInUs) && Objects.equals(this.userIoWaitTimeInUs, other.userIoWaitTimeInUs) && Objects.equals(this.plsqlExecTimeInUs, other.plsqlExecTimeInUs) && Objects.equals(this.javaExecTimeInUs, other.javaExecTimeInUs) && Objects.equals(this.sorts, other.sorts) && Objects.equals(this.sharableMem, other.sharableMem) && Objects.equals(this.totalSharableMem, other.totalSharableMem) && Objects.equals(this.typeCheckMem, other.typeCheckMem) && Objects.equals(this.ioCellOffloadEligibleBytes, other.ioCellOffloadEligibleBytes) && Objects.equals(this.ioInterconnectBytes, other.ioInterconnectBytes) && Objects.equals(this.physicalReadRequests, other.physicalReadRequests) && Objects.equals(this.physicalReadBytes, other.physicalReadBytes) && Objects.equals(this.physicalWriteRequests, other.physicalWriteRequests) && Objects.equals(this.physicalWriteBytes, other.physicalWriteBytes) && Objects.equals(this.exactMatchingSignature, other.exactMatchingSignature) && Objects.equals(this.forceMatchingSignature, other.forceMatchingSignature) && Objects.equals(this.ioCellUncompressedBytes, other.ioCellUncompressedBytes) && Objects.equals(this.ioCellOffloadReturnedBytes, other.ioCellOffloadReturnedBytes) && Objects.equals(this.childNumber, other.childNumber) && Objects.equals(this.commandType, other.commandType) && Objects.equals(this.usersOpening, other.usersOpening) && Objects.equals(this.usersExecuting, other.usersExecuting) && Objects.equals(this.optimizerCost, other.optimizerCost) && Objects.equals(this.fullPlanHashValue, other.fullPlanHashValue) && Objects.equals(this.module, other.module) && Objects.equals(this.service, other.service) && Objects.equals(this.action, other.action) && Objects.equals(this.sqlProfile, other.sqlProfile) && Objects.equals(this.sqlPatch, other.sqlPatch) && Objects.equals(this.sqlPlanBaseline, other.sqlPlanBaseline) && Objects.equals(this.deltaExecutionCount, other.deltaExecutionCount) && Objects.equals(this.deltaCpuTime, other.deltaCpuTime) && Objects.equals(this.deltaIoBytes, other.deltaIoBytes) && Objects.equals(this.deltaCpuRank, other.deltaCpuRank) && Objects.equals(this.deltaExecsRank, other.deltaExecsRank) && Objects.equals(this.sharableMemRank, other.sharableMemRank) && Objects.equals(this.deltaIoRank, other.deltaIoRank) && Objects.equals(this.harmonicSum, other.harmonicSum) && Objects.equals(this.wtHarmonicSum, other.wtHarmonicSum) && Objects.equals(this.totalSqlCount, other.totalSqlCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.sqlIdentifier == null ? 43 : this.sqlIdentifier.hashCode());
        result = result * 59 + (this.planHashValue == null ? 43 : this.planHashValue.hashCode());
        result = result * 59 + (this.timeCollected == null ? 43 : this.timeCollected.hashCode());
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.lastActiveTime == null ? 43 : this.lastActiveTime.hashCode());
        result = result * 59 + (this.parseCalls == null ? 43 : this.parseCalls.hashCode());
        result = result * 59 + (this.diskReads == null ? 43 : this.diskReads.hashCode());
        result = result * 59 + (this.directReads == null ? 43 : this.directReads.hashCode());
        result = result * 59 + (this.directWrites == null ? 43 : this.directWrites.hashCode());
        result = result * 59 + (this.bufferGets == null ? 43 : this.bufferGets.hashCode());
        result = result * 59 + (this.rowsProcessed == null ? 43 : this.rowsProcessed.hashCode());
        result = result * 59 + (this.serializableAborts == null ? 43 : this.serializableAborts.hashCode());
        result = result * 59 + (this.fetches == null ? 43 : this.fetches.hashCode());
        result = result * 59 + (this.executions == null ? 43 : this.executions.hashCode());
        result = result * 59 + (this.avoidedExecutions == null ? 43 : this.avoidedExecutions.hashCode());
        result = result * 59 + (this.endOfFetchCount == null ? 43 : this.endOfFetchCount.hashCode());
        result = result * 59 + (this.loads == null ? 43 : this.loads.hashCode());
        result = result * 59 + (this.versionCount == null ? 43 : this.versionCount.hashCode());
        result = result * 59 + (this.invalidations == null ? 43 : this.invalidations.hashCode());
        result = result * 59 + (this.obsoleteCount == null ? 43 : this.obsoleteCount.hashCode());
        result = result * 59 + (this.pxServersExecutions == null ? 43 : this.pxServersExecutions.hashCode());
        result = result * 59 + (this.cpuTimeInUs == null ? 43 : this.cpuTimeInUs.hashCode());
        result = result * 59 + (this.elapsedTimeInUs == null ? 43 : this.elapsedTimeInUs.hashCode());
        result = result * 59 + (this.avgHardParseTimeInUs == null ? 43 : this.avgHardParseTimeInUs.hashCode());
        result = result * 59 + (this.concurrencyWaitTimeInUs == null ? 43 : this.concurrencyWaitTimeInUs.hashCode());
        result = result * 59 + (this.applicationWaitTimeInUs == null ? 43 : this.applicationWaitTimeInUs.hashCode());
        result = result * 59 + (this.clusterWaitTimeInUs == null ? 43 : this.clusterWaitTimeInUs.hashCode());
        result = result * 59 + (this.userIoWaitTimeInUs == null ? 43 : this.userIoWaitTimeInUs.hashCode());
        result = result * 59 + (this.plsqlExecTimeInUs == null ? 43 : this.plsqlExecTimeInUs.hashCode());
        result = result * 59 + (this.javaExecTimeInUs == null ? 43 : this.javaExecTimeInUs.hashCode());
        result = result * 59 + (this.sorts == null ? 43 : this.sorts.hashCode());
        result = result * 59 + (this.sharableMem == null ? 43 : this.sharableMem.hashCode());
        result = result * 59 + (this.totalSharableMem == null ? 43 : this.totalSharableMem.hashCode());
        result = result * 59 + (this.typeCheckMem == null ? 43 : this.typeCheckMem.hashCode());
        result = result * 59 + (this.ioCellOffloadEligibleBytes == null ? 43 : this.ioCellOffloadEligibleBytes.hashCode());
        result = result * 59 + (this.ioInterconnectBytes == null ? 43 : this.ioInterconnectBytes.hashCode());
        result = result * 59 + (this.physicalReadRequests == null ? 43 : this.physicalReadRequests.hashCode());
        result = result * 59 + (this.physicalReadBytes == null ? 43 : this.physicalReadBytes.hashCode());
        result = result * 59 + (this.physicalWriteRequests == null ? 43 : this.physicalWriteRequests.hashCode());
        result = result * 59 + (this.physicalWriteBytes == null ? 43 : this.physicalWriteBytes.hashCode());
        result = result * 59 + (this.exactMatchingSignature == null ? 43 : this.exactMatchingSignature.hashCode());
        result = result * 59 + (this.forceMatchingSignature == null ? 43 : this.forceMatchingSignature.hashCode());
        result = result * 59 + (this.ioCellUncompressedBytes == null ? 43 : this.ioCellUncompressedBytes.hashCode());
        result = result * 59 + (this.ioCellOffloadReturnedBytes == null ? 43 : this.ioCellOffloadReturnedBytes.hashCode());
        result = result * 59 + (this.childNumber == null ? 43 : this.childNumber.hashCode());
        result = result * 59 + (this.commandType == null ? 43 : this.commandType.hashCode());
        result = result * 59 + (this.usersOpening == null ? 43 : this.usersOpening.hashCode());
        result = result * 59 + (this.usersExecuting == null ? 43 : this.usersExecuting.hashCode());
        result = result * 59 + (this.optimizerCost == null ? 43 : this.optimizerCost.hashCode());
        result = result * 59 + (this.fullPlanHashValue == null ? 43 : this.fullPlanHashValue.hashCode());
        result = result * 59 + (this.module == null ? 43 : this.module.hashCode());
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.sqlProfile == null ? 43 : this.sqlProfile.hashCode());
        result = result * 59 + (this.sqlPatch == null ? 43 : this.sqlPatch.hashCode());
        result = result * 59 + (this.sqlPlanBaseline == null ? 43 : this.sqlPlanBaseline.hashCode());
        result = result * 59 + (this.deltaExecutionCount == null ? 43 : this.deltaExecutionCount.hashCode());
        result = result * 59 + (this.deltaCpuTime == null ? 43 : this.deltaCpuTime.hashCode());
        result = result * 59 + (this.deltaIoBytes == null ? 43 : this.deltaIoBytes.hashCode());
        result = result * 59 + (this.deltaCpuRank == null ? 43 : this.deltaCpuRank.hashCode());
        result = result * 59 + (this.deltaExecsRank == null ? 43 : this.deltaExecsRank.hashCode());
        result = result * 59 + (this.sharableMemRank == null ? 43 : this.sharableMemRank.hashCode());
        result = result * 59 + (this.deltaIoRank == null ? 43 : this.deltaIoRank.hashCode());
        result = result * 59 + (this.harmonicSum == null ? 43 : this.harmonicSum.hashCode());
        result = result * 59 + (this.wtHarmonicSum == null ? 43 : this.wtHarmonicSum.hashCode());
        result = result * 59 + (this.totalSqlCount == null ? 43 : this.totalSqlCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sqlIdentifier")
        private String sqlIdentifier;
        @JsonProperty(value="planHashValue")
        private Long planHashValue;
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="lastActiveTime")
        private String lastActiveTime;
        @JsonProperty(value="parseCalls")
        private Long parseCalls;
        @JsonProperty(value="diskReads")
        private Long diskReads;
        @JsonProperty(value="directReads")
        private Long directReads;
        @JsonProperty(value="directWrites")
        private Long directWrites;
        @JsonProperty(value="bufferGets")
        private Long bufferGets;
        @JsonProperty(value="rowsProcessed")
        private Long rowsProcessed;
        @JsonProperty(value="serializableAborts")
        private Long serializableAborts;
        @JsonProperty(value="fetches")
        private Long fetches;
        @JsonProperty(value="executions")
        private Long executions;
        @JsonProperty(value="avoidedExecutions")
        private Long avoidedExecutions;
        @JsonProperty(value="endOfFetchCount")
        private Long endOfFetchCount;
        @JsonProperty(value="loads")
        private Long loads;
        @JsonProperty(value="versionCount")
        private Long versionCount;
        @JsonProperty(value="invalidations")
        private Long invalidations;
        @JsonProperty(value="obsoleteCount")
        private Long obsoleteCount;
        @JsonProperty(value="pxServersExecutions")
        private Long pxServersExecutions;
        @JsonProperty(value="cpuTimeInUs")
        private Long cpuTimeInUs;
        @JsonProperty(value="elapsedTimeInUs")
        private Long elapsedTimeInUs;
        @JsonProperty(value="avgHardParseTimeInUs")
        private Long avgHardParseTimeInUs;
        @JsonProperty(value="concurrencyWaitTimeInUs")
        private Long concurrencyWaitTimeInUs;
        @JsonProperty(value="applicationWaitTimeInUs")
        private Long applicationWaitTimeInUs;
        @JsonProperty(value="clusterWaitTimeInUs")
        private Long clusterWaitTimeInUs;
        @JsonProperty(value="userIoWaitTimeInUs")
        private Long userIoWaitTimeInUs;
        @JsonProperty(value="plsqlExecTimeInUs")
        private Long plsqlExecTimeInUs;
        @JsonProperty(value="javaExecTimeInUs")
        private Long javaExecTimeInUs;
        @JsonProperty(value="sorts")
        private Long sorts;
        @JsonProperty(value="sharableMem")
        private Long sharableMem;
        @JsonProperty(value="totalSharableMem")
        private Long totalSharableMem;
        @JsonProperty(value="typeCheckMem")
        private Long typeCheckMem;
        @JsonProperty(value="ioCellOffloadEligibleBytes")
        private Long ioCellOffloadEligibleBytes;
        @JsonProperty(value="ioInterconnectBytes")
        private Long ioInterconnectBytes;
        @JsonProperty(value="physicalReadRequests")
        private Long physicalReadRequests;
        @JsonProperty(value="physicalReadBytes")
        private Long physicalReadBytes;
        @JsonProperty(value="physicalWriteRequests")
        private Long physicalWriteRequests;
        @JsonProperty(value="physicalWriteBytes")
        private Long physicalWriteBytes;
        @JsonProperty(value="exactMatchingSignature")
        private String exactMatchingSignature;
        @JsonProperty(value="forceMatchingSignature")
        private String forceMatchingSignature;
        @JsonProperty(value="ioCellUncompressedBytes")
        private Long ioCellUncompressedBytes;
        @JsonProperty(value="ioCellOffloadReturnedBytes")
        private Long ioCellOffloadReturnedBytes;
        @JsonProperty(value="childNumber")
        private Long childNumber;
        @JsonProperty(value="commandType")
        private Long commandType;
        @JsonProperty(value="usersOpening")
        private Long usersOpening;
        @JsonProperty(value="usersExecuting")
        private Long usersExecuting;
        @JsonProperty(value="optimizerCost")
        private Long optimizerCost;
        @JsonProperty(value="fullPlanHashValue")
        private String fullPlanHashValue;
        @JsonProperty(value="module")
        private String module;
        @JsonProperty(value="service")
        private String service;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="sqlProfile")
        private String sqlProfile;
        @JsonProperty(value="sqlPatch")
        private String sqlPatch;
        @JsonProperty(value="sqlPlanBaseline")
        private String sqlPlanBaseline;
        @JsonProperty(value="deltaExecutionCount")
        private Long deltaExecutionCount;
        @JsonProperty(value="deltaCpuTime")
        private Long deltaCpuTime;
        @JsonProperty(value="deltaIoBytes")
        private Long deltaIoBytes;
        @JsonProperty(value="deltaCpuRank")
        private Long deltaCpuRank;
        @JsonProperty(value="deltaExecsRank")
        private Long deltaExecsRank;
        @JsonProperty(value="sharableMemRank")
        private Long sharableMemRank;
        @JsonProperty(value="deltaIoRank")
        private Long deltaIoRank;
        @JsonProperty(value="harmonicSum")
        private Long harmonicSum;
        @JsonProperty(value="wtHarmonicSum")
        private Long wtHarmonicSum;
        @JsonProperty(value="totalSqlCount")
        private Long totalSqlCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sqlIdentifier(String sqlIdentifier) {
            this.sqlIdentifier = sqlIdentifier;
            this.__explicitlySet__.add("sqlIdentifier");
            return this;
        }

        public Builder planHashValue(Long planHashValue) {
            this.planHashValue = planHashValue;
            this.__explicitlySet__.add("planHashValue");
            return this;
        }

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder lastActiveTime(String lastActiveTime) {
            this.lastActiveTime = lastActiveTime;
            this.__explicitlySet__.add("lastActiveTime");
            return this;
        }

        public Builder parseCalls(Long parseCalls) {
            this.parseCalls = parseCalls;
            this.__explicitlySet__.add("parseCalls");
            return this;
        }

        public Builder diskReads(Long diskReads) {
            this.diskReads = diskReads;
            this.__explicitlySet__.add("diskReads");
            return this;
        }

        public Builder directReads(Long directReads) {
            this.directReads = directReads;
            this.__explicitlySet__.add("directReads");
            return this;
        }

        public Builder directWrites(Long directWrites) {
            this.directWrites = directWrites;
            this.__explicitlySet__.add("directWrites");
            return this;
        }

        public Builder bufferGets(Long bufferGets) {
            this.bufferGets = bufferGets;
            this.__explicitlySet__.add("bufferGets");
            return this;
        }

        public Builder rowsProcessed(Long rowsProcessed) {
            this.rowsProcessed = rowsProcessed;
            this.__explicitlySet__.add("rowsProcessed");
            return this;
        }

        public Builder serializableAborts(Long serializableAborts) {
            this.serializableAborts = serializableAborts;
            this.__explicitlySet__.add("serializableAborts");
            return this;
        }

        public Builder fetches(Long fetches) {
            this.fetches = fetches;
            this.__explicitlySet__.add("fetches");
            return this;
        }

        public Builder executions(Long executions) {
            this.executions = executions;
            this.__explicitlySet__.add("executions");
            return this;
        }

        public Builder avoidedExecutions(Long avoidedExecutions) {
            this.avoidedExecutions = avoidedExecutions;
            this.__explicitlySet__.add("avoidedExecutions");
            return this;
        }

        public Builder endOfFetchCount(Long endOfFetchCount) {
            this.endOfFetchCount = endOfFetchCount;
            this.__explicitlySet__.add("endOfFetchCount");
            return this;
        }

        public Builder loads(Long loads) {
            this.loads = loads;
            this.__explicitlySet__.add("loads");
            return this;
        }

        public Builder versionCount(Long versionCount) {
            this.versionCount = versionCount;
            this.__explicitlySet__.add("versionCount");
            return this;
        }

        public Builder invalidations(Long invalidations) {
            this.invalidations = invalidations;
            this.__explicitlySet__.add("invalidations");
            return this;
        }

        public Builder obsoleteCount(Long obsoleteCount) {
            this.obsoleteCount = obsoleteCount;
            this.__explicitlySet__.add("obsoleteCount");
            return this;
        }

        public Builder pxServersExecutions(Long pxServersExecutions) {
            this.pxServersExecutions = pxServersExecutions;
            this.__explicitlySet__.add("pxServersExecutions");
            return this;
        }

        public Builder cpuTimeInUs(Long cpuTimeInUs) {
            this.cpuTimeInUs = cpuTimeInUs;
            this.__explicitlySet__.add("cpuTimeInUs");
            return this;
        }

        public Builder elapsedTimeInUs(Long elapsedTimeInUs) {
            this.elapsedTimeInUs = elapsedTimeInUs;
            this.__explicitlySet__.add("elapsedTimeInUs");
            return this;
        }

        public Builder avgHardParseTimeInUs(Long avgHardParseTimeInUs) {
            this.avgHardParseTimeInUs = avgHardParseTimeInUs;
            this.__explicitlySet__.add("avgHardParseTimeInUs");
            return this;
        }

        public Builder concurrencyWaitTimeInUs(Long concurrencyWaitTimeInUs) {
            this.concurrencyWaitTimeInUs = concurrencyWaitTimeInUs;
            this.__explicitlySet__.add("concurrencyWaitTimeInUs");
            return this;
        }

        public Builder applicationWaitTimeInUs(Long applicationWaitTimeInUs) {
            this.applicationWaitTimeInUs = applicationWaitTimeInUs;
            this.__explicitlySet__.add("applicationWaitTimeInUs");
            return this;
        }

        public Builder clusterWaitTimeInUs(Long clusterWaitTimeInUs) {
            this.clusterWaitTimeInUs = clusterWaitTimeInUs;
            this.__explicitlySet__.add("clusterWaitTimeInUs");
            return this;
        }

        public Builder userIoWaitTimeInUs(Long userIoWaitTimeInUs) {
            this.userIoWaitTimeInUs = userIoWaitTimeInUs;
            this.__explicitlySet__.add("userIoWaitTimeInUs");
            return this;
        }

        public Builder plsqlExecTimeInUs(Long plsqlExecTimeInUs) {
            this.plsqlExecTimeInUs = plsqlExecTimeInUs;
            this.__explicitlySet__.add("plsqlExecTimeInUs");
            return this;
        }

        public Builder javaExecTimeInUs(Long javaExecTimeInUs) {
            this.javaExecTimeInUs = javaExecTimeInUs;
            this.__explicitlySet__.add("javaExecTimeInUs");
            return this;
        }

        public Builder sorts(Long sorts) {
            this.sorts = sorts;
            this.__explicitlySet__.add("sorts");
            return this;
        }

        public Builder sharableMem(Long sharableMem) {
            this.sharableMem = sharableMem;
            this.__explicitlySet__.add("sharableMem");
            return this;
        }

        public Builder totalSharableMem(Long totalSharableMem) {
            this.totalSharableMem = totalSharableMem;
            this.__explicitlySet__.add("totalSharableMem");
            return this;
        }

        public Builder typeCheckMem(Long typeCheckMem) {
            this.typeCheckMem = typeCheckMem;
            this.__explicitlySet__.add("typeCheckMem");
            return this;
        }

        public Builder ioCellOffloadEligibleBytes(Long ioCellOffloadEligibleBytes) {
            this.ioCellOffloadEligibleBytes = ioCellOffloadEligibleBytes;
            this.__explicitlySet__.add("ioCellOffloadEligibleBytes");
            return this;
        }

        public Builder ioInterconnectBytes(Long ioInterconnectBytes) {
            this.ioInterconnectBytes = ioInterconnectBytes;
            this.__explicitlySet__.add("ioInterconnectBytes");
            return this;
        }

        public Builder physicalReadRequests(Long physicalReadRequests) {
            this.physicalReadRequests = physicalReadRequests;
            this.__explicitlySet__.add("physicalReadRequests");
            return this;
        }

        public Builder physicalReadBytes(Long physicalReadBytes) {
            this.physicalReadBytes = physicalReadBytes;
            this.__explicitlySet__.add("physicalReadBytes");
            return this;
        }

        public Builder physicalWriteRequests(Long physicalWriteRequests) {
            this.physicalWriteRequests = physicalWriteRequests;
            this.__explicitlySet__.add("physicalWriteRequests");
            return this;
        }

        public Builder physicalWriteBytes(Long physicalWriteBytes) {
            this.physicalWriteBytes = physicalWriteBytes;
            this.__explicitlySet__.add("physicalWriteBytes");
            return this;
        }

        public Builder exactMatchingSignature(String exactMatchingSignature) {
            this.exactMatchingSignature = exactMatchingSignature;
            this.__explicitlySet__.add("exactMatchingSignature");
            return this;
        }

        public Builder forceMatchingSignature(String forceMatchingSignature) {
            this.forceMatchingSignature = forceMatchingSignature;
            this.__explicitlySet__.add("forceMatchingSignature");
            return this;
        }

        public Builder ioCellUncompressedBytes(Long ioCellUncompressedBytes) {
            this.ioCellUncompressedBytes = ioCellUncompressedBytes;
            this.__explicitlySet__.add("ioCellUncompressedBytes");
            return this;
        }

        public Builder ioCellOffloadReturnedBytes(Long ioCellOffloadReturnedBytes) {
            this.ioCellOffloadReturnedBytes = ioCellOffloadReturnedBytes;
            this.__explicitlySet__.add("ioCellOffloadReturnedBytes");
            return this;
        }

        public Builder childNumber(Long childNumber) {
            this.childNumber = childNumber;
            this.__explicitlySet__.add("childNumber");
            return this;
        }

        public Builder commandType(Long commandType) {
            this.commandType = commandType;
            this.__explicitlySet__.add("commandType");
            return this;
        }

        public Builder usersOpening(Long usersOpening) {
            this.usersOpening = usersOpening;
            this.__explicitlySet__.add("usersOpening");
            return this;
        }

        public Builder usersExecuting(Long usersExecuting) {
            this.usersExecuting = usersExecuting;
            this.__explicitlySet__.add("usersExecuting");
            return this;
        }

        public Builder optimizerCost(Long optimizerCost) {
            this.optimizerCost = optimizerCost;
            this.__explicitlySet__.add("optimizerCost");
            return this;
        }

        public Builder fullPlanHashValue(String fullPlanHashValue) {
            this.fullPlanHashValue = fullPlanHashValue;
            this.__explicitlySet__.add("fullPlanHashValue");
            return this;
        }

        public Builder module(String module) {
            this.module = module;
            this.__explicitlySet__.add("module");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder sqlProfile(String sqlProfile) {
            this.sqlProfile = sqlProfile;
            this.__explicitlySet__.add("sqlProfile");
            return this;
        }

        public Builder sqlPatch(String sqlPatch) {
            this.sqlPatch = sqlPatch;
            this.__explicitlySet__.add("sqlPatch");
            return this;
        }

        public Builder sqlPlanBaseline(String sqlPlanBaseline) {
            this.sqlPlanBaseline = sqlPlanBaseline;
            this.__explicitlySet__.add("sqlPlanBaseline");
            return this;
        }

        public Builder deltaExecutionCount(Long deltaExecutionCount) {
            this.deltaExecutionCount = deltaExecutionCount;
            this.__explicitlySet__.add("deltaExecutionCount");
            return this;
        }

        public Builder deltaCpuTime(Long deltaCpuTime) {
            this.deltaCpuTime = deltaCpuTime;
            this.__explicitlySet__.add("deltaCpuTime");
            return this;
        }

        public Builder deltaIoBytes(Long deltaIoBytes) {
            this.deltaIoBytes = deltaIoBytes;
            this.__explicitlySet__.add("deltaIoBytes");
            return this;
        }

        public Builder deltaCpuRank(Long deltaCpuRank) {
            this.deltaCpuRank = deltaCpuRank;
            this.__explicitlySet__.add("deltaCpuRank");
            return this;
        }

        public Builder deltaExecsRank(Long deltaExecsRank) {
            this.deltaExecsRank = deltaExecsRank;
            this.__explicitlySet__.add("deltaExecsRank");
            return this;
        }

        public Builder sharableMemRank(Long sharableMemRank) {
            this.sharableMemRank = sharableMemRank;
            this.__explicitlySet__.add("sharableMemRank");
            return this;
        }

        public Builder deltaIoRank(Long deltaIoRank) {
            this.deltaIoRank = deltaIoRank;
            this.__explicitlySet__.add("deltaIoRank");
            return this;
        }

        public Builder harmonicSum(Long harmonicSum) {
            this.harmonicSum = harmonicSum;
            this.__explicitlySet__.add("harmonicSum");
            return this;
        }

        public Builder wtHarmonicSum(Long wtHarmonicSum) {
            this.wtHarmonicSum = wtHarmonicSum;
            this.__explicitlySet__.add("wtHarmonicSum");
            return this;
        }

        public Builder totalSqlCount(Long totalSqlCount) {
            this.totalSqlCount = totalSqlCount;
            this.__explicitlySet__.add("totalSqlCount");
            return this;
        }

        public SqlStats build() {
            SqlStats model = new SqlStats(this.sqlIdentifier, this.planHashValue, this.timeCollected, this.instanceName, this.lastActiveTime, this.parseCalls, this.diskReads, this.directReads, this.directWrites, this.bufferGets, this.rowsProcessed, this.serializableAborts, this.fetches, this.executions, this.avoidedExecutions, this.endOfFetchCount, this.loads, this.versionCount, this.invalidations, this.obsoleteCount, this.pxServersExecutions, this.cpuTimeInUs, this.elapsedTimeInUs, this.avgHardParseTimeInUs, this.concurrencyWaitTimeInUs, this.applicationWaitTimeInUs, this.clusterWaitTimeInUs, this.userIoWaitTimeInUs, this.plsqlExecTimeInUs, this.javaExecTimeInUs, this.sorts, this.sharableMem, this.totalSharableMem, this.typeCheckMem, this.ioCellOffloadEligibleBytes, this.ioInterconnectBytes, this.physicalReadRequests, this.physicalReadBytes, this.physicalWriteRequests, this.physicalWriteBytes, this.exactMatchingSignature, this.forceMatchingSignature, this.ioCellUncompressedBytes, this.ioCellOffloadReturnedBytes, this.childNumber, this.commandType, this.usersOpening, this.usersExecuting, this.optimizerCost, this.fullPlanHashValue, this.module, this.service, this.action, this.sqlProfile, this.sqlPatch, this.sqlPlanBaseline, this.deltaExecutionCount, this.deltaCpuTime, this.deltaIoBytes, this.deltaCpuRank, this.deltaExecsRank, this.sharableMemRank, this.deltaIoRank, this.harmonicSum, this.wtHarmonicSum, this.totalSqlCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlStats model) {
            if (model.wasPropertyExplicitlySet("sqlIdentifier")) {
                this.sqlIdentifier(model.getSqlIdentifier());
            }
            if (model.wasPropertyExplicitlySet("planHashValue")) {
                this.planHashValue(model.getPlanHashValue());
            }
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("lastActiveTime")) {
                this.lastActiveTime(model.getLastActiveTime());
            }
            if (model.wasPropertyExplicitlySet("parseCalls")) {
                this.parseCalls(model.getParseCalls());
            }
            if (model.wasPropertyExplicitlySet("diskReads")) {
                this.diskReads(model.getDiskReads());
            }
            if (model.wasPropertyExplicitlySet("directReads")) {
                this.directReads(model.getDirectReads());
            }
            if (model.wasPropertyExplicitlySet("directWrites")) {
                this.directWrites(model.getDirectWrites());
            }
            if (model.wasPropertyExplicitlySet("bufferGets")) {
                this.bufferGets(model.getBufferGets());
            }
            if (model.wasPropertyExplicitlySet("rowsProcessed")) {
                this.rowsProcessed(model.getRowsProcessed());
            }
            if (model.wasPropertyExplicitlySet("serializableAborts")) {
                this.serializableAborts(model.getSerializableAborts());
            }
            if (model.wasPropertyExplicitlySet("fetches")) {
                this.fetches(model.getFetches());
            }
            if (model.wasPropertyExplicitlySet("executions")) {
                this.executions(model.getExecutions());
            }
            if (model.wasPropertyExplicitlySet("avoidedExecutions")) {
                this.avoidedExecutions(model.getAvoidedExecutions());
            }
            if (model.wasPropertyExplicitlySet("endOfFetchCount")) {
                this.endOfFetchCount(model.getEndOfFetchCount());
            }
            if (model.wasPropertyExplicitlySet("loads")) {
                this.loads(model.getLoads());
            }
            if (model.wasPropertyExplicitlySet("versionCount")) {
                this.versionCount(model.getVersionCount());
            }
            if (model.wasPropertyExplicitlySet("invalidations")) {
                this.invalidations(model.getInvalidations());
            }
            if (model.wasPropertyExplicitlySet("obsoleteCount")) {
                this.obsoleteCount(model.getObsoleteCount());
            }
            if (model.wasPropertyExplicitlySet("pxServersExecutions")) {
                this.pxServersExecutions(model.getPxServersExecutions());
            }
            if (model.wasPropertyExplicitlySet("cpuTimeInUs")) {
                this.cpuTimeInUs(model.getCpuTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("elapsedTimeInUs")) {
                this.elapsedTimeInUs(model.getElapsedTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("avgHardParseTimeInUs")) {
                this.avgHardParseTimeInUs(model.getAvgHardParseTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("concurrencyWaitTimeInUs")) {
                this.concurrencyWaitTimeInUs(model.getConcurrencyWaitTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("applicationWaitTimeInUs")) {
                this.applicationWaitTimeInUs(model.getApplicationWaitTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("clusterWaitTimeInUs")) {
                this.clusterWaitTimeInUs(model.getClusterWaitTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("userIoWaitTimeInUs")) {
                this.userIoWaitTimeInUs(model.getUserIoWaitTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("plsqlExecTimeInUs")) {
                this.plsqlExecTimeInUs(model.getPlsqlExecTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("javaExecTimeInUs")) {
                this.javaExecTimeInUs(model.getJavaExecTimeInUs());
            }
            if (model.wasPropertyExplicitlySet("sorts")) {
                this.sorts(model.getSorts());
            }
            if (model.wasPropertyExplicitlySet("sharableMem")) {
                this.sharableMem(model.getSharableMem());
            }
            if (model.wasPropertyExplicitlySet("totalSharableMem")) {
                this.totalSharableMem(model.getTotalSharableMem());
            }
            if (model.wasPropertyExplicitlySet("typeCheckMem")) {
                this.typeCheckMem(model.getTypeCheckMem());
            }
            if (model.wasPropertyExplicitlySet("ioCellOffloadEligibleBytes")) {
                this.ioCellOffloadEligibleBytes(model.getIoCellOffloadEligibleBytes());
            }
            if (model.wasPropertyExplicitlySet("ioInterconnectBytes")) {
                this.ioInterconnectBytes(model.getIoInterconnectBytes());
            }
            if (model.wasPropertyExplicitlySet("physicalReadRequests")) {
                this.physicalReadRequests(model.getPhysicalReadRequests());
            }
            if (model.wasPropertyExplicitlySet("physicalReadBytes")) {
                this.physicalReadBytes(model.getPhysicalReadBytes());
            }
            if (model.wasPropertyExplicitlySet("physicalWriteRequests")) {
                this.physicalWriteRequests(model.getPhysicalWriteRequests());
            }
            if (model.wasPropertyExplicitlySet("physicalWriteBytes")) {
                this.physicalWriteBytes(model.getPhysicalWriteBytes());
            }
            if (model.wasPropertyExplicitlySet("exactMatchingSignature")) {
                this.exactMatchingSignature(model.getExactMatchingSignature());
            }
            if (model.wasPropertyExplicitlySet("forceMatchingSignature")) {
                this.forceMatchingSignature(model.getForceMatchingSignature());
            }
            if (model.wasPropertyExplicitlySet("ioCellUncompressedBytes")) {
                this.ioCellUncompressedBytes(model.getIoCellUncompressedBytes());
            }
            if (model.wasPropertyExplicitlySet("ioCellOffloadReturnedBytes")) {
                this.ioCellOffloadReturnedBytes(model.getIoCellOffloadReturnedBytes());
            }
            if (model.wasPropertyExplicitlySet("childNumber")) {
                this.childNumber(model.getChildNumber());
            }
            if (model.wasPropertyExplicitlySet("commandType")) {
                this.commandType(model.getCommandType());
            }
            if (model.wasPropertyExplicitlySet("usersOpening")) {
                this.usersOpening(model.getUsersOpening());
            }
            if (model.wasPropertyExplicitlySet("usersExecuting")) {
                this.usersExecuting(model.getUsersExecuting());
            }
            if (model.wasPropertyExplicitlySet("optimizerCost")) {
                this.optimizerCost(model.getOptimizerCost());
            }
            if (model.wasPropertyExplicitlySet("fullPlanHashValue")) {
                this.fullPlanHashValue(model.getFullPlanHashValue());
            }
            if (model.wasPropertyExplicitlySet("module")) {
                this.module(model.getModule());
            }
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("sqlProfile")) {
                this.sqlProfile(model.getSqlProfile());
            }
            if (model.wasPropertyExplicitlySet("sqlPatch")) {
                this.sqlPatch(model.getSqlPatch());
            }
            if (model.wasPropertyExplicitlySet("sqlPlanBaseline")) {
                this.sqlPlanBaseline(model.getSqlPlanBaseline());
            }
            if (model.wasPropertyExplicitlySet("deltaExecutionCount")) {
                this.deltaExecutionCount(model.getDeltaExecutionCount());
            }
            if (model.wasPropertyExplicitlySet("deltaCpuTime")) {
                this.deltaCpuTime(model.getDeltaCpuTime());
            }
            if (model.wasPropertyExplicitlySet("deltaIoBytes")) {
                this.deltaIoBytes(model.getDeltaIoBytes());
            }
            if (model.wasPropertyExplicitlySet("deltaCpuRank")) {
                this.deltaCpuRank(model.getDeltaCpuRank());
            }
            if (model.wasPropertyExplicitlySet("deltaExecsRank")) {
                this.deltaExecsRank(model.getDeltaExecsRank());
            }
            if (model.wasPropertyExplicitlySet("sharableMemRank")) {
                this.sharableMemRank(model.getSharableMemRank());
            }
            if (model.wasPropertyExplicitlySet("deltaIoRank")) {
                this.deltaIoRank(model.getDeltaIoRank());
            }
            if (model.wasPropertyExplicitlySet("harmonicSum")) {
                this.harmonicSum(model.getHarmonicSum());
            }
            if (model.wasPropertyExplicitlySet("wtHarmonicSum")) {
                this.wtHarmonicSum(model.getWtHarmonicSum());
            }
            if (model.wasPropertyExplicitlySet("totalSqlCount")) {
                this.totalSqlCount(model.getTotalSqlCount());
            }
            return this;
        }
    }
}

