/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResourceCapacityTrendAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="endTimestamp")
    private final Date endTimestamp;
    @JsonProperty(value="capacity")
    private final Double capacity;
    @JsonProperty(value="baseCapacity")
    private final Double baseCapacity;
    @JsonProperty(value="totalHostCapacity")
    private final Double totalHostCapacity;

    @Deprecated
    @ConstructorProperties(value={"endTimestamp", "capacity", "baseCapacity", "totalHostCapacity"})
    public ResourceCapacityTrendAggregation(Date endTimestamp, Double capacity, Double baseCapacity, Double totalHostCapacity) {
        this.endTimestamp = endTimestamp;
        this.capacity = capacity;
        this.baseCapacity = baseCapacity;
        this.totalHostCapacity = totalHostCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public Double getCapacity() {
        return this.capacity;
    }

    public Double getBaseCapacity() {
        return this.baseCapacity;
    }

    public Double getTotalHostCapacity() {
        return this.totalHostCapacity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResourceCapacityTrendAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("endTimestamp=").append(String.valueOf(this.endTimestamp));
        sb.append(", capacity=").append(String.valueOf(this.capacity));
        sb.append(", baseCapacity=").append(String.valueOf(this.baseCapacity));
        sb.append(", totalHostCapacity=").append(String.valueOf(this.totalHostCapacity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceCapacityTrendAggregation)) {
            return false;
        }
        ResourceCapacityTrendAggregation other = (ResourceCapacityTrendAggregation)((Object)o);
        return Objects.equals(this.endTimestamp, other.endTimestamp) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.baseCapacity, other.baseCapacity) && Objects.equals(this.totalHostCapacity, other.totalHostCapacity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.endTimestamp == null ? 43 : this.endTimestamp.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.baseCapacity == null ? 43 : this.baseCapacity.hashCode());
        result = result * 59 + (this.totalHostCapacity == null ? 43 : this.totalHostCapacity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="endTimestamp")
        private Date endTimestamp;
        @JsonProperty(value="capacity")
        private Double capacity;
        @JsonProperty(value="baseCapacity")
        private Double baseCapacity;
        @JsonProperty(value="totalHostCapacity")
        private Double totalHostCapacity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder endTimestamp(Date endTimestamp) {
            this.endTimestamp = endTimestamp;
            this.__explicitlySet__.add("endTimestamp");
            return this;
        }

        public Builder capacity(Double capacity) {
            this.capacity = capacity;
            this.__explicitlySet__.add("capacity");
            return this;
        }

        public Builder baseCapacity(Double baseCapacity) {
            this.baseCapacity = baseCapacity;
            this.__explicitlySet__.add("baseCapacity");
            return this;
        }

        public Builder totalHostCapacity(Double totalHostCapacity) {
            this.totalHostCapacity = totalHostCapacity;
            this.__explicitlySet__.add("totalHostCapacity");
            return this;
        }

        public ResourceCapacityTrendAggregation build() {
            ResourceCapacityTrendAggregation model = new ResourceCapacityTrendAggregation(this.endTimestamp, this.capacity, this.baseCapacity, this.totalHostCapacity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResourceCapacityTrendAggregation model) {
            if (model.wasPropertyExplicitlySet("endTimestamp")) {
                this.endTimestamp(model.getEndTimestamp());
            }
            if (model.wasPropertyExplicitlySet("capacity")) {
                this.capacity(model.getCapacity());
            }
            if (model.wasPropertyExplicitlySet("baseCapacity")) {
                this.baseCapacity(model.getBaseCapacity());
            }
            if (model.wasPropertyExplicitlySet("totalHostCapacity")) {
                this.totalHostCapacity(model.getTotalHostCapacity());
            }
            return this;
        }
    }
}

