/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostTopProcesses
extends HostPerformanceMetricGroup {
    @JsonProperty(value="pid")
    private final BigDecimal pid;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="memoryUtilizationPercent")
    private final Double memoryUtilizationPercent;
    @JsonProperty(value="cpuUtilizationPercent")
    private final Double cpuUtilizationPercent;
    @JsonProperty(value="cpuUsageInSeconds")
    private final Double cpuUsageInSeconds;
    @JsonProperty(value="command")
    private final String command;
    @JsonProperty(value="virtualMemoryInMBs")
    private final Double virtualMemoryInMBs;
    @JsonProperty(value="physicalMemoryInMBs")
    private final Double physicalMemoryInMBs;
    @JsonProperty(value="startTime")
    private final Date startTime;
    @JsonProperty(value="totalProcesses")
    private final BigDecimal totalProcesses;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostTopProcesses(Date timeCollected, BigDecimal pid, String userName, Double memoryUtilizationPercent, Double cpuUtilizationPercent, Double cpuUsageInSeconds, String command, Double virtualMemoryInMBs, Double physicalMemoryInMBs, Date startTime, BigDecimal totalProcesses) {
        super(timeCollected);
        this.pid = pid;
        this.userName = userName;
        this.memoryUtilizationPercent = memoryUtilizationPercent;
        this.cpuUtilizationPercent = cpuUtilizationPercent;
        this.cpuUsageInSeconds = cpuUsageInSeconds;
        this.command = command;
        this.virtualMemoryInMBs = virtualMemoryInMBs;
        this.physicalMemoryInMBs = physicalMemoryInMBs;
        this.startTime = startTime;
        this.totalProcesses = totalProcesses;
    }

    public BigDecimal getPid() {
        return this.pid;
    }

    public String getUserName() {
        return this.userName;
    }

    public Double getMemoryUtilizationPercent() {
        return this.memoryUtilizationPercent;
    }

    public Double getCpuUtilizationPercent() {
        return this.cpuUtilizationPercent;
    }

    public Double getCpuUsageInSeconds() {
        return this.cpuUsageInSeconds;
    }

    public String getCommand() {
        return this.command;
    }

    public Double getVirtualMemoryInMBs() {
        return this.virtualMemoryInMBs;
    }

    public Double getPhysicalMemoryInMBs() {
        return this.physicalMemoryInMBs;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public BigDecimal getTotalProcesses() {
        return this.totalProcesses;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostTopProcesses(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", pid=").append(String.valueOf(this.pid));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", memoryUtilizationPercent=").append(String.valueOf(this.memoryUtilizationPercent));
        sb.append(", cpuUtilizationPercent=").append(String.valueOf(this.cpuUtilizationPercent));
        sb.append(", cpuUsageInSeconds=").append(String.valueOf(this.cpuUsageInSeconds));
        sb.append(", command=").append(String.valueOf(this.command));
        sb.append(", virtualMemoryInMBs=").append(String.valueOf(this.virtualMemoryInMBs));
        sb.append(", physicalMemoryInMBs=").append(String.valueOf(this.physicalMemoryInMBs));
        sb.append(", startTime=").append(String.valueOf(this.startTime));
        sb.append(", totalProcesses=").append(String.valueOf(this.totalProcesses));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostTopProcesses)) {
            return false;
        }
        HostTopProcesses other = (HostTopProcesses)((Object)o);
        return Objects.equals(this.pid, other.pid) && Objects.equals(this.userName, other.userName) && Objects.equals(this.memoryUtilizationPercent, other.memoryUtilizationPercent) && Objects.equals(this.cpuUtilizationPercent, other.cpuUtilizationPercent) && Objects.equals(this.cpuUsageInSeconds, other.cpuUsageInSeconds) && Objects.equals(this.command, other.command) && Objects.equals(this.virtualMemoryInMBs, other.virtualMemoryInMBs) && Objects.equals(this.physicalMemoryInMBs, other.physicalMemoryInMBs) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.totalProcesses, other.totalProcesses) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pid == null ? 43 : this.pid.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.memoryUtilizationPercent == null ? 43 : this.memoryUtilizationPercent.hashCode());
        result = result * 59 + (this.cpuUtilizationPercent == null ? 43 : this.cpuUtilizationPercent.hashCode());
        result = result * 59 + (this.cpuUsageInSeconds == null ? 43 : this.cpuUsageInSeconds.hashCode());
        result = result * 59 + (this.command == null ? 43 : this.command.hashCode());
        result = result * 59 + (this.virtualMemoryInMBs == null ? 43 : this.virtualMemoryInMBs.hashCode());
        result = result * 59 + (this.physicalMemoryInMBs == null ? 43 : this.physicalMemoryInMBs.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.totalProcesses == null ? 43 : this.totalProcesses.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="pid")
        private BigDecimal pid;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="memoryUtilizationPercent")
        private Double memoryUtilizationPercent;
        @JsonProperty(value="cpuUtilizationPercent")
        private Double cpuUtilizationPercent;
        @JsonProperty(value="cpuUsageInSeconds")
        private Double cpuUsageInSeconds;
        @JsonProperty(value="command")
        private String command;
        @JsonProperty(value="virtualMemoryInMBs")
        private Double virtualMemoryInMBs;
        @JsonProperty(value="physicalMemoryInMBs")
        private Double physicalMemoryInMBs;
        @JsonProperty(value="startTime")
        private Date startTime;
        @JsonProperty(value="totalProcesses")
        private BigDecimal totalProcesses;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder pid(BigDecimal pid) {
            this.pid = pid;
            this.__explicitlySet__.add("pid");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder memoryUtilizationPercent(Double memoryUtilizationPercent) {
            this.memoryUtilizationPercent = memoryUtilizationPercent;
            this.__explicitlySet__.add("memoryUtilizationPercent");
            return this;
        }

        public Builder cpuUtilizationPercent(Double cpuUtilizationPercent) {
            this.cpuUtilizationPercent = cpuUtilizationPercent;
            this.__explicitlySet__.add("cpuUtilizationPercent");
            return this;
        }

        public Builder cpuUsageInSeconds(Double cpuUsageInSeconds) {
            this.cpuUsageInSeconds = cpuUsageInSeconds;
            this.__explicitlySet__.add("cpuUsageInSeconds");
            return this;
        }

        public Builder command(String command) {
            this.command = command;
            this.__explicitlySet__.add("command");
            return this;
        }

        public Builder virtualMemoryInMBs(Double virtualMemoryInMBs) {
            this.virtualMemoryInMBs = virtualMemoryInMBs;
            this.__explicitlySet__.add("virtualMemoryInMBs");
            return this;
        }

        public Builder physicalMemoryInMBs(Double physicalMemoryInMBs) {
            this.physicalMemoryInMBs = physicalMemoryInMBs;
            this.__explicitlySet__.add("physicalMemoryInMBs");
            return this;
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder totalProcesses(BigDecimal totalProcesses) {
            this.totalProcesses = totalProcesses;
            this.__explicitlySet__.add("totalProcesses");
            return this;
        }

        public HostTopProcesses build() {
            HostTopProcesses model = new HostTopProcesses(this.timeCollected, this.pid, this.userName, this.memoryUtilizationPercent, this.cpuUtilizationPercent, this.cpuUsageInSeconds, this.command, this.virtualMemoryInMBs, this.physicalMemoryInMBs, this.startTime, this.totalProcesses);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostTopProcesses model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("pid")) {
                this.pid(model.getPid());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("memoryUtilizationPercent")) {
                this.memoryUtilizationPercent(model.getMemoryUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuUtilizationPercent")) {
                this.cpuUtilizationPercent(model.getCpuUtilizationPercent());
            }
            if (model.wasPropertyExplicitlySet("cpuUsageInSeconds")) {
                this.cpuUsageInSeconds(model.getCpuUsageInSeconds());
            }
            if (model.wasPropertyExplicitlySet("command")) {
                this.command(model.getCommand());
            }
            if (model.wasPropertyExplicitlySet("virtualMemoryInMBs")) {
                this.virtualMemoryInMBs(model.getVirtualMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("physicalMemoryInMBs")) {
                this.physicalMemoryInMBs(model.getPhysicalMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("totalProcesses")) {
                this.totalProcesses(model.getTotalProcesses());
            }
            return this;
        }
    }
}

