/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.HostCpuStatistics;
import com.oracle.bmc.opsi.model.HostMemoryStatistics;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceName", defaultImpl=HostResourceStatistics.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HostMemoryStatistics.class, name="HOST_MEMORY_STATISTICS"), @JsonSubTypes.Type(value=HostCpuStatistics.class, name="HOST_CPU_STATISTICS")})
@JsonFilter(value="explicitlySetFilter")
public class HostResourceStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="usage")
    private final Double usage;
    @JsonProperty(value="capacity")
    private final Double capacity;
    @JsonProperty(value="utilizationPercent")
    private final Double utilizationPercent;
    @JsonProperty(value="usageChangePercent")
    private final Double usageChangePercent;

    @Deprecated
    @ConstructorProperties(value={"usage", "capacity", "utilizationPercent", "usageChangePercent"})
    protected HostResourceStatistics(Double usage, Double capacity, Double utilizationPercent, Double usageChangePercent) {
        this.usage = usage;
        this.capacity = capacity;
        this.utilizationPercent = utilizationPercent;
        this.usageChangePercent = usageChangePercent;
    }

    public Double getUsage() {
        return this.usage;
    }

    public Double getCapacity() {
        return this.capacity;
    }

    public Double getUtilizationPercent() {
        return this.utilizationPercent;
    }

    public Double getUsageChangePercent() {
        return this.usageChangePercent;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostResourceStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("usage=").append(String.valueOf(this.usage));
        sb.append(", capacity=").append(String.valueOf(this.capacity));
        sb.append(", utilizationPercent=").append(String.valueOf(this.utilizationPercent));
        sb.append(", usageChangePercent=").append(String.valueOf(this.usageChangePercent));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostResourceStatistics)) {
            return false;
        }
        HostResourceStatistics other = (HostResourceStatistics)((Object)o);
        return Objects.equals(this.usage, other.usage) && Objects.equals(this.capacity, other.capacity) && Objects.equals(this.utilizationPercent, other.utilizationPercent) && Objects.equals(this.usageChangePercent, other.usageChangePercent) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.usage == null ? 43 : this.usage.hashCode());
        result = result * 59 + (this.capacity == null ? 43 : this.capacity.hashCode());
        result = result * 59 + (this.utilizationPercent == null ? 43 : this.utilizationPercent.hashCode());
        result = result * 59 + (this.usageChangePercent == null ? 43 : this.usageChangePercent.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceName implements BmcEnum
    {
        HostCpuStatistics("HOST_CPU_STATISTICS"),
        HostMemoryStatistics("HOST_MEMORY_STATISTICS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceName> map;

        private ResourceName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceName.class);
            map = new HashMap<String, ResourceName>();
            for (ResourceName v : ResourceName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

