/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.HostPerformanceMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class HostNetworkActivitySummary
extends HostPerformanceMetricGroup {
    @JsonProperty(value="allNetworkReadInMbps")
    private final Double allNetworkReadInMbps;
    @JsonProperty(value="allNetworkWriteInMbps")
    private final Double allNetworkWriteInMbps;
    @JsonProperty(value="allNetworkIoInMbps")
    private final Double allNetworkIoInMbps;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostNetworkActivitySummary(Date timeCollected, Double allNetworkReadInMbps, Double allNetworkWriteInMbps, Double allNetworkIoInMbps) {
        super(timeCollected);
        this.allNetworkReadInMbps = allNetworkReadInMbps;
        this.allNetworkWriteInMbps = allNetworkWriteInMbps;
        this.allNetworkIoInMbps = allNetworkIoInMbps;
    }

    public Double getAllNetworkReadInMbps() {
        return this.allNetworkReadInMbps;
    }

    public Double getAllNetworkWriteInMbps() {
        return this.allNetworkWriteInMbps;
    }

    public Double getAllNetworkIoInMbps() {
        return this.allNetworkIoInMbps;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostNetworkActivitySummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", allNetworkReadInMbps=").append(String.valueOf(this.allNetworkReadInMbps));
        sb.append(", allNetworkWriteInMbps=").append(String.valueOf(this.allNetworkWriteInMbps));
        sb.append(", allNetworkIoInMbps=").append(String.valueOf(this.allNetworkIoInMbps));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostNetworkActivitySummary)) {
            return false;
        }
        HostNetworkActivitySummary other = (HostNetworkActivitySummary)((Object)o);
        return Objects.equals(this.allNetworkReadInMbps, other.allNetworkReadInMbps) && Objects.equals(this.allNetworkWriteInMbps, other.allNetworkWriteInMbps) && Objects.equals(this.allNetworkIoInMbps, other.allNetworkIoInMbps) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.allNetworkReadInMbps == null ? 43 : this.allNetworkReadInMbps.hashCode());
        result = result * 59 + (this.allNetworkWriteInMbps == null ? 43 : this.allNetworkWriteInMbps.hashCode());
        result = result * 59 + (this.allNetworkIoInMbps == null ? 43 : this.allNetworkIoInMbps.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="allNetworkReadInMbps")
        private Double allNetworkReadInMbps;
        @JsonProperty(value="allNetworkWriteInMbps")
        private Double allNetworkWriteInMbps;
        @JsonProperty(value="allNetworkIoInMbps")
        private Double allNetworkIoInMbps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder allNetworkReadInMbps(Double allNetworkReadInMbps) {
            this.allNetworkReadInMbps = allNetworkReadInMbps;
            this.__explicitlySet__.add("allNetworkReadInMbps");
            return this;
        }

        public Builder allNetworkWriteInMbps(Double allNetworkWriteInMbps) {
            this.allNetworkWriteInMbps = allNetworkWriteInMbps;
            this.__explicitlySet__.add("allNetworkWriteInMbps");
            return this;
        }

        public Builder allNetworkIoInMbps(Double allNetworkIoInMbps) {
            this.allNetworkIoInMbps = allNetworkIoInMbps;
            this.__explicitlySet__.add("allNetworkIoInMbps");
            return this;
        }

        public HostNetworkActivitySummary build() {
            HostNetworkActivitySummary model = new HostNetworkActivitySummary(this.timeCollected, this.allNetworkReadInMbps, this.allNetworkWriteInMbps, this.allNetworkIoInMbps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostNetworkActivitySummary model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("allNetworkReadInMbps")) {
                this.allNetworkReadInMbps(model.getAllNetworkReadInMbps());
            }
            if (model.wasPropertyExplicitlySet("allNetworkWriteInMbps")) {
                this.allNetworkWriteInMbps(model.getAllNetworkWriteInMbps());
            }
            if (model.wasPropertyExplicitlySet("allNetworkIoInMbps")) {
                this.allNetworkIoInMbps(model.getAllNetworkIoInMbps());
            }
            return this;
        }
    }
}

