/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum DatabaseEntitySource implements BmcEnum
{
    EmManagedExternalDatabase("EM_MANAGED_EXTERNAL_DATABASE"),
    PeComanagedDatabase("PE_COMANAGED_DATABASE");

    private final String value;
    private static Map<String, DatabaseEntitySource> map;

    private DatabaseEntitySource(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static DatabaseEntitySource create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid DatabaseEntitySource: " + key);
    }

    static {
        map = new HashMap<String, DatabaseEntitySource>();
        for (DatabaseEntitySource v : DatabaseEntitySource.values()) {
            map.put(v.getValue(), v);
        }
    }
}

