/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum Database implements BmcEnum
{
    Cpu("CPU"),
    Storage("STORAGE"),
    Io("IO"),
    Memory("MEMORY");

    private final String value;
    private static Map<String, Database> map;

    private Database(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static Database create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid Database: " + key);
    }

    static {
        map = new HashMap<String, Database>();
        for (Database v : Database.values()) {
            map.put(v.getValue(), v);
        }
    }
}

