/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DataObjectQuery;
import com.oracle.bmc.opsi.model.DataObjectQueryTimeFilters;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="queryType")
@JsonFilter(value="explicitlySetFilter")
public final class DataObjectTemplatizedQuery
extends DataObjectQuery {
    @JsonProperty(value="selectList")
    private final List<String> selectList;
    @JsonProperty(value="whereConditionsList")
    private final List<String> whereConditionsList;
    @JsonProperty(value="groupByList")
    private final List<String> groupByList;
    @JsonProperty(value="havingConditionsList")
    private final List<String> havingConditionsList;
    @JsonProperty(value="orderByList")
    private final List<String> orderByList;
    @JsonProperty(value="timeFilters")
    private final DataObjectQueryTimeFilters timeFilters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DataObjectTemplatizedQuery(List<String> selectList, List<String> whereConditionsList, List<String> groupByList, List<String> havingConditionsList, List<String> orderByList, DataObjectQueryTimeFilters timeFilters) {
        this.selectList = selectList;
        this.whereConditionsList = whereConditionsList;
        this.groupByList = groupByList;
        this.havingConditionsList = havingConditionsList;
        this.orderByList = orderByList;
        this.timeFilters = timeFilters;
    }

    public List<String> getSelectList() {
        return this.selectList;
    }

    public List<String> getWhereConditionsList() {
        return this.whereConditionsList;
    }

    public List<String> getGroupByList() {
        return this.groupByList;
    }

    public List<String> getHavingConditionsList() {
        return this.havingConditionsList;
    }

    public List<String> getOrderByList() {
        return this.orderByList;
    }

    public DataObjectQueryTimeFilters getTimeFilters() {
        return this.timeFilters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataObjectTemplatizedQuery(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", selectList=").append(String.valueOf(this.selectList));
        sb.append(", whereConditionsList=").append(String.valueOf(this.whereConditionsList));
        sb.append(", groupByList=").append(String.valueOf(this.groupByList));
        sb.append(", havingConditionsList=").append(String.valueOf(this.havingConditionsList));
        sb.append(", orderByList=").append(String.valueOf(this.orderByList));
        sb.append(", timeFilters=").append(String.valueOf((Object)this.timeFilters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataObjectTemplatizedQuery)) {
            return false;
        }
        DataObjectTemplatizedQuery other = (DataObjectTemplatizedQuery)((Object)o);
        return Objects.equals(this.selectList, other.selectList) && Objects.equals(this.whereConditionsList, other.whereConditionsList) && Objects.equals(this.groupByList, other.groupByList) && Objects.equals(this.havingConditionsList, other.havingConditionsList) && Objects.equals(this.orderByList, other.orderByList) && Objects.equals((Object)this.timeFilters, (Object)other.timeFilters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.selectList == null ? 43 : this.selectList.hashCode());
        result = result * 59 + (this.whereConditionsList == null ? 43 : this.whereConditionsList.hashCode());
        result = result * 59 + (this.groupByList == null ? 43 : this.groupByList.hashCode());
        result = result * 59 + (this.havingConditionsList == null ? 43 : this.havingConditionsList.hashCode());
        result = result * 59 + (this.orderByList == null ? 43 : this.orderByList.hashCode());
        result = result * 59 + (this.timeFilters == null ? 43 : this.timeFilters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="selectList")
        private List<String> selectList;
        @JsonProperty(value="whereConditionsList")
        private List<String> whereConditionsList;
        @JsonProperty(value="groupByList")
        private List<String> groupByList;
        @JsonProperty(value="havingConditionsList")
        private List<String> havingConditionsList;
        @JsonProperty(value="orderByList")
        private List<String> orderByList;
        @JsonProperty(value="timeFilters")
        private DataObjectQueryTimeFilters timeFilters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder selectList(List<String> selectList) {
            this.selectList = selectList;
            this.__explicitlySet__.add("selectList");
            return this;
        }

        public Builder whereConditionsList(List<String> whereConditionsList) {
            this.whereConditionsList = whereConditionsList;
            this.__explicitlySet__.add("whereConditionsList");
            return this;
        }

        public Builder groupByList(List<String> groupByList) {
            this.groupByList = groupByList;
            this.__explicitlySet__.add("groupByList");
            return this;
        }

        public Builder havingConditionsList(List<String> havingConditionsList) {
            this.havingConditionsList = havingConditionsList;
            this.__explicitlySet__.add("havingConditionsList");
            return this;
        }

        public Builder orderByList(List<String> orderByList) {
            this.orderByList = orderByList;
            this.__explicitlySet__.add("orderByList");
            return this;
        }

        public Builder timeFilters(DataObjectQueryTimeFilters timeFilters) {
            this.timeFilters = timeFilters;
            this.__explicitlySet__.add("timeFilters");
            return this;
        }

        public DataObjectTemplatizedQuery build() {
            DataObjectTemplatizedQuery model = new DataObjectTemplatizedQuery(this.selectList, this.whereConditionsList, this.groupByList, this.havingConditionsList, this.orderByList, this.timeFilters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataObjectTemplatizedQuery model) {
            if (model.wasPropertyExplicitlySet("selectList")) {
                this.selectList(model.getSelectList());
            }
            if (model.wasPropertyExplicitlySet("whereConditionsList")) {
                this.whereConditionsList(model.getWhereConditionsList());
            }
            if (model.wasPropertyExplicitlySet("groupByList")) {
                this.groupByList(model.getGroupByList());
            }
            if (model.wasPropertyExplicitlySet("havingConditionsList")) {
                this.havingConditionsList(model.getHavingConditionsList());
            }
            if (model.wasPropertyExplicitlySet("orderByList")) {
                this.orderByList(model.getOrderByList());
            }
            if (model.wasPropertyExplicitlySet("timeFilters")) {
                this.timeFilters(model.getTimeFilters());
            }
            return this;
        }
    }
}

