/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class DBOSConfigInstance
extends DatabaseConfigurationMetricGroup {
    @JsonProperty(value="instanceName")
    private final String instanceName;
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="numCPUs")
    private final Integer numCPUs;
    @JsonProperty(value="numCPUCores")
    private final Integer numCPUCores;
    @JsonProperty(value="numCPUSockets")
    private final Integer numCPUSockets;
    @JsonProperty(value="physicalMemoryBytes")
    private final Double physicalMemoryBytes;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DBOSConfigInstance(Date timeCollected, String instanceName, String hostName, Integer numCPUs, Integer numCPUCores, Integer numCPUSockets, Double physicalMemoryBytes) {
        super(timeCollected);
        this.instanceName = instanceName;
        this.hostName = hostName;
        this.numCPUs = numCPUs;
        this.numCPUCores = numCPUCores;
        this.numCPUSockets = numCPUSockets;
        this.physicalMemoryBytes = physicalMemoryBytes;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getNumCPUs() {
        return this.numCPUs;
    }

    public Integer getNumCPUCores() {
        return this.numCPUCores;
    }

    public Integer getNumCPUSockets() {
        return this.numCPUSockets;
    }

    public Double getPhysicalMemoryBytes() {
        return this.physicalMemoryBytes;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DBOSConfigInstance(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", instanceName=").append(String.valueOf(this.instanceName));
        sb.append(", hostName=").append(String.valueOf(this.hostName));
        sb.append(", numCPUs=").append(String.valueOf(this.numCPUs));
        sb.append(", numCPUCores=").append(String.valueOf(this.numCPUCores));
        sb.append(", numCPUSockets=").append(String.valueOf(this.numCPUSockets));
        sb.append(", physicalMemoryBytes=").append(String.valueOf(this.physicalMemoryBytes));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DBOSConfigInstance)) {
            return false;
        }
        DBOSConfigInstance other = (DBOSConfigInstance)((Object)o);
        return Objects.equals(this.instanceName, other.instanceName) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.numCPUs, other.numCPUs) && Objects.equals(this.numCPUCores, other.numCPUCores) && Objects.equals(this.numCPUSockets, other.numCPUSockets) && Objects.equals(this.physicalMemoryBytes, other.physicalMemoryBytes) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceName == null ? 43 : this.instanceName.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.numCPUs == null ? 43 : this.numCPUs.hashCode());
        result = result * 59 + (this.numCPUCores == null ? 43 : this.numCPUCores.hashCode());
        result = result * 59 + (this.numCPUSockets == null ? 43 : this.numCPUSockets.hashCode());
        result = result * 59 + (this.physicalMemoryBytes == null ? 43 : this.physicalMemoryBytes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="hostName")
        private String hostName;
        @JsonProperty(value="numCPUs")
        private Integer numCPUs;
        @JsonProperty(value="numCPUCores")
        private Integer numCPUCores;
        @JsonProperty(value="numCPUSockets")
        private Integer numCPUSockets;
        @JsonProperty(value="physicalMemoryBytes")
        private Double physicalMemoryBytes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            this.__explicitlySet__.add("instanceName");
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            this.__explicitlySet__.add("hostName");
            return this;
        }

        public Builder numCPUs(Integer numCPUs) {
            this.numCPUs = numCPUs;
            this.__explicitlySet__.add("numCPUs");
            return this;
        }

        public Builder numCPUCores(Integer numCPUCores) {
            this.numCPUCores = numCPUCores;
            this.__explicitlySet__.add("numCPUCores");
            return this;
        }

        public Builder numCPUSockets(Integer numCPUSockets) {
            this.numCPUSockets = numCPUSockets;
            this.__explicitlySet__.add("numCPUSockets");
            return this;
        }

        public Builder physicalMemoryBytes(Double physicalMemoryBytes) {
            this.physicalMemoryBytes = physicalMemoryBytes;
            this.__explicitlySet__.add("physicalMemoryBytes");
            return this;
        }

        public DBOSConfigInstance build() {
            DBOSConfigInstance model = new DBOSConfigInstance(this.timeCollected, this.instanceName, this.hostName, this.numCPUs, this.numCPUCores, this.numCPUSockets, this.physicalMemoryBytes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DBOSConfigInstance model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("instanceName")) {
                this.instanceName(model.getInstanceName());
            }
            if (model.wasPropertyExplicitlySet("hostName")) {
                this.hostName(model.getHostName());
            }
            if (model.wasPropertyExplicitlySet("numCPUs")) {
                this.numCPUs(model.getNumCPUs());
            }
            if (model.wasPropertyExplicitlySet("numCPUCores")) {
                this.numCPUCores(model.getNumCPUCores());
            }
            if (model.wasPropertyExplicitlySet("numCPUSockets")) {
                this.numCPUSockets(model.getNumCPUSockets());
            }
            if (model.wasPropertyExplicitlySet("physicalMemoryBytes")) {
                this.physicalMemoryBytes(model.getPhysicalMemoryBytes());
            }
            return this;
        }
    }
}

