/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.DatabaseConfigurationMetricGroup;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricName")
@JsonFilter(value="explicitlySetFilter")
public final class DBExternalProperties
extends DatabaseConfigurationMetricGroup {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="logMode")
    private final String logMode;
    @JsonProperty(value="cdb")
    private final String cdb;
    @JsonProperty(value="openMode")
    private final String openMode;
    @JsonProperty(value="databaseRole")
    private final String databaseRole;
    @JsonProperty(value="guardStatus")
    private final String guardStatus;
    @JsonProperty(value="platformName")
    private final String platformName;
    @JsonProperty(value="controlFileType")
    private final String controlFileType;
    @JsonProperty(value="switchoverStatus")
    private final String switchoverStatus;
    @JsonProperty(value="created")
    private final Date created;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DBExternalProperties(Date timeCollected, String name, String logMode, String cdb, String openMode, String databaseRole, String guardStatus, String platformName, String controlFileType, String switchoverStatus, Date created) {
        super(timeCollected);
        this.name = name;
        this.logMode = logMode;
        this.cdb = cdb;
        this.openMode = openMode;
        this.databaseRole = databaseRole;
        this.guardStatus = guardStatus;
        this.platformName = platformName;
        this.controlFileType = controlFileType;
        this.switchoverStatus = switchoverStatus;
        this.created = created;
    }

    public String getName() {
        return this.name;
    }

    public String getLogMode() {
        return this.logMode;
    }

    public String getCdb() {
        return this.cdb;
    }

    public String getOpenMode() {
        return this.openMode;
    }

    public String getDatabaseRole() {
        return this.databaseRole;
    }

    public String getGuardStatus() {
        return this.guardStatus;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getControlFileType() {
        return this.controlFileType;
    }

    public String getSwitchoverStatus() {
        return this.switchoverStatus;
    }

    public Date getCreated() {
        return this.created;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DBExternalProperties(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", logMode=").append(String.valueOf(this.logMode));
        sb.append(", cdb=").append(String.valueOf(this.cdb));
        sb.append(", openMode=").append(String.valueOf(this.openMode));
        sb.append(", databaseRole=").append(String.valueOf(this.databaseRole));
        sb.append(", guardStatus=").append(String.valueOf(this.guardStatus));
        sb.append(", platformName=").append(String.valueOf(this.platformName));
        sb.append(", controlFileType=").append(String.valueOf(this.controlFileType));
        sb.append(", switchoverStatus=").append(String.valueOf(this.switchoverStatus));
        sb.append(", created=").append(String.valueOf(this.created));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DBExternalProperties)) {
            return false;
        }
        DBExternalProperties other = (DBExternalProperties)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.logMode, other.logMode) && Objects.equals(this.cdb, other.cdb) && Objects.equals(this.openMode, other.openMode) && Objects.equals(this.databaseRole, other.databaseRole) && Objects.equals(this.guardStatus, other.guardStatus) && Objects.equals(this.platformName, other.platformName) && Objects.equals(this.controlFileType, other.controlFileType) && Objects.equals(this.switchoverStatus, other.switchoverStatus) && Objects.equals(this.created, other.created) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.logMode == null ? 43 : this.logMode.hashCode());
        result = result * 59 + (this.cdb == null ? 43 : this.cdb.hashCode());
        result = result * 59 + (this.openMode == null ? 43 : this.openMode.hashCode());
        result = result * 59 + (this.databaseRole == null ? 43 : this.databaseRole.hashCode());
        result = result * 59 + (this.guardStatus == null ? 43 : this.guardStatus.hashCode());
        result = result * 59 + (this.platformName == null ? 43 : this.platformName.hashCode());
        result = result * 59 + (this.controlFileType == null ? 43 : this.controlFileType.hashCode());
        result = result * 59 + (this.switchoverStatus == null ? 43 : this.switchoverStatus.hashCode());
        result = result * 59 + (this.created == null ? 43 : this.created.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="logMode")
        private String logMode;
        @JsonProperty(value="cdb")
        private String cdb;
        @JsonProperty(value="openMode")
        private String openMode;
        @JsonProperty(value="databaseRole")
        private String databaseRole;
        @JsonProperty(value="guardStatus")
        private String guardStatus;
        @JsonProperty(value="platformName")
        private String platformName;
        @JsonProperty(value="controlFileType")
        private String controlFileType;
        @JsonProperty(value="switchoverStatus")
        private String switchoverStatus;
        @JsonProperty(value="created")
        private Date created;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder logMode(String logMode) {
            this.logMode = logMode;
            this.__explicitlySet__.add("logMode");
            return this;
        }

        public Builder cdb(String cdb) {
            this.cdb = cdb;
            this.__explicitlySet__.add("cdb");
            return this;
        }

        public Builder openMode(String openMode) {
            this.openMode = openMode;
            this.__explicitlySet__.add("openMode");
            return this;
        }

        public Builder databaseRole(String databaseRole) {
            this.databaseRole = databaseRole;
            this.__explicitlySet__.add("databaseRole");
            return this;
        }

        public Builder guardStatus(String guardStatus) {
            this.guardStatus = guardStatus;
            this.__explicitlySet__.add("guardStatus");
            return this;
        }

        public Builder platformName(String platformName) {
            this.platformName = platformName;
            this.__explicitlySet__.add("platformName");
            return this;
        }

        public Builder controlFileType(String controlFileType) {
            this.controlFileType = controlFileType;
            this.__explicitlySet__.add("controlFileType");
            return this;
        }

        public Builder switchoverStatus(String switchoverStatus) {
            this.switchoverStatus = switchoverStatus;
            this.__explicitlySet__.add("switchoverStatus");
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            this.__explicitlySet__.add("created");
            return this;
        }

        public DBExternalProperties build() {
            DBExternalProperties model = new DBExternalProperties(this.timeCollected, this.name, this.logMode, this.cdb, this.openMode, this.databaseRole, this.guardStatus, this.platformName, this.controlFileType, this.switchoverStatus, this.created);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DBExternalProperties model) {
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("logMode")) {
                this.logMode(model.getLogMode());
            }
            if (model.wasPropertyExplicitlySet("cdb")) {
                this.cdb(model.getCdb());
            }
            if (model.wasPropertyExplicitlySet("openMode")) {
                this.openMode(model.getOpenMode());
            }
            if (model.wasPropertyExplicitlySet("databaseRole")) {
                this.databaseRole(model.getDatabaseRole());
            }
            if (model.wasPropertyExplicitlySet("guardStatus")) {
                this.guardStatus(model.getGuardStatus());
            }
            if (model.wasPropertyExplicitlySet("platformName")) {
                this.platformName(model.getPlatformName());
            }
            if (model.wasPropertyExplicitlySet("controlFileType")) {
                this.controlFileType(model.getControlFileType());
            }
            if (model.wasPropertyExplicitlySet("switchoverStatus")) {
                this.switchoverStatus(model.getSwitchoverStatus());
            }
            if (model.wasPropertyExplicitlySet("created")) {
                this.created(model.getCreated());
            }
            return this;
        }
    }
}

