/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.opsi.model.CredentialDetails;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="credentialType")
@JsonFilter(value="explicitlySetFilter")
public final class CredentialByVault
extends CredentialDetails {
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="passwordSecretId")
    private final String passwordSecretId;
    @JsonProperty(value="role")
    private final Role role;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CredentialByVault(String credentialSourceName, String userName, String passwordSecretId, Role role) {
        super(credentialSourceName);
        this.userName = userName;
        this.passwordSecretId = passwordSecretId;
        this.role = role;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPasswordSecretId() {
        return this.passwordSecretId;
    }

    public Role getRole() {
        return this.role;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CredentialByVault(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", passwordSecretId=").append(String.valueOf(this.passwordSecretId));
        sb.append(", role=").append(String.valueOf((Object)this.role));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CredentialByVault)) {
            return false;
        }
        CredentialByVault other = (CredentialByVault)((Object)o);
        return Objects.equals(this.userName, other.userName) && Objects.equals(this.passwordSecretId, other.passwordSecretId) && Objects.equals((Object)this.role, (Object)other.role) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.passwordSecretId == null ? 43 : this.passwordSecretId.hashCode());
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        return result;
    }

    public static enum Role implements BmcEnum
    {
        Normal("NORMAL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="credentialSourceName")
        private String credentialSourceName;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="passwordSecretId")
        private String passwordSecretId;
        @JsonProperty(value="role")
        private Role role;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder credentialSourceName(String credentialSourceName) {
            this.credentialSourceName = credentialSourceName;
            this.__explicitlySet__.add("credentialSourceName");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder passwordSecretId(String passwordSecretId) {
            this.passwordSecretId = passwordSecretId;
            this.__explicitlySet__.add("passwordSecretId");
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public CredentialByVault build() {
            CredentialByVault model = new CredentialByVault(this.credentialSourceName, this.userName, this.passwordSecretId, this.role);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CredentialByVault model) {
            if (model.wasPropertyExplicitlySet("credentialSourceName")) {
                this.credentialSourceName(model.getCredentialSourceName());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("passwordSecretId")) {
                this.passwordSecretId(model.getPasswordSecretId());
            }
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            return this;
        }
    }
}

