/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opsi.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.opsi.model.AwrDatabaseCpuUsageSummary;
import com.oracle.bmc.opsi.model.AwrQueryResult;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="awrResultType")
@JsonFilter(value="explicitlySetFilter")
public final class AwrDatabaseCpuUsageCollection
extends AwrQueryResult {
    @JsonProperty(value="numCpuCores")
    private final Integer numCpuCores;
    @JsonProperty(value="databaseCpuCount")
    private final Integer databaseCpuCount;
    @JsonProperty(value="hostCpuCount")
    private final Double hostCpuCount;
    @JsonProperty(value="items")
    private final List<AwrDatabaseCpuUsageSummary> items;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AwrDatabaseCpuUsageCollection(String name, String version, Double dbQueryTimeInSecs, Integer numCpuCores, Integer databaseCpuCount, Double hostCpuCount, List<AwrDatabaseCpuUsageSummary> items) {
        super(name, version, dbQueryTimeInSecs);
        this.numCpuCores = numCpuCores;
        this.databaseCpuCount = databaseCpuCount;
        this.hostCpuCount = hostCpuCount;
        this.items = items;
    }

    public Integer getNumCpuCores() {
        return this.numCpuCores;
    }

    public Integer getDatabaseCpuCount() {
        return this.databaseCpuCount;
    }

    public Double getHostCpuCount() {
        return this.hostCpuCount;
    }

    public List<AwrDatabaseCpuUsageSummary> getItems() {
        return this.items;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AwrDatabaseCpuUsageCollection(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", numCpuCores=").append(String.valueOf(this.numCpuCores));
        sb.append(", databaseCpuCount=").append(String.valueOf(this.databaseCpuCount));
        sb.append(", hostCpuCount=").append(String.valueOf(this.hostCpuCount));
        sb.append(", items=").append(String.valueOf(this.items));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwrDatabaseCpuUsageCollection)) {
            return false;
        }
        AwrDatabaseCpuUsageCollection other = (AwrDatabaseCpuUsageCollection)((Object)o);
        return Objects.equals(this.numCpuCores, other.numCpuCores) && Objects.equals(this.databaseCpuCount, other.databaseCpuCount) && Objects.equals(this.hostCpuCount, other.hostCpuCount) && Objects.equals(this.items, other.items) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.numCpuCores == null ? 43 : this.numCpuCores.hashCode());
        result = result * 59 + (this.databaseCpuCount == null ? 43 : this.databaseCpuCount.hashCode());
        result = result * 59 + (this.hostCpuCount == null ? 43 : this.hostCpuCount.hashCode());
        result = result * 59 + (this.items == null ? 43 : this.items.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="dbQueryTimeInSecs")
        private Double dbQueryTimeInSecs;
        @JsonProperty(value="numCpuCores")
        private Integer numCpuCores;
        @JsonProperty(value="databaseCpuCount")
        private Integer databaseCpuCount;
        @JsonProperty(value="hostCpuCount")
        private Double hostCpuCount;
        @JsonProperty(value="items")
        private List<AwrDatabaseCpuUsageSummary> items;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder dbQueryTimeInSecs(Double dbQueryTimeInSecs) {
            this.dbQueryTimeInSecs = dbQueryTimeInSecs;
            this.__explicitlySet__.add("dbQueryTimeInSecs");
            return this;
        }

        public Builder numCpuCores(Integer numCpuCores) {
            this.numCpuCores = numCpuCores;
            this.__explicitlySet__.add("numCpuCores");
            return this;
        }

        public Builder databaseCpuCount(Integer databaseCpuCount) {
            this.databaseCpuCount = databaseCpuCount;
            this.__explicitlySet__.add("databaseCpuCount");
            return this;
        }

        public Builder hostCpuCount(Double hostCpuCount) {
            this.hostCpuCount = hostCpuCount;
            this.__explicitlySet__.add("hostCpuCount");
            return this;
        }

        public Builder items(List<AwrDatabaseCpuUsageSummary> items) {
            this.items = items;
            this.__explicitlySet__.add("items");
            return this;
        }

        public AwrDatabaseCpuUsageCollection build() {
            AwrDatabaseCpuUsageCollection model = new AwrDatabaseCpuUsageCollection(this.name, this.version, this.dbQueryTimeInSecs, this.numCpuCores, this.databaseCpuCount, this.hostCpuCount, this.items);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AwrDatabaseCpuUsageCollection model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("dbQueryTimeInSecs")) {
                this.dbQueryTimeInSecs(model.getDbQueryTimeInSecs());
            }
            if (model.wasPropertyExplicitlySet("numCpuCores")) {
                this.numCpuCores(model.getNumCpuCores());
            }
            if (model.wasPropertyExplicitlySet("databaseCpuCount")) {
                this.databaseCpuCount(model.getDatabaseCpuCount());
            }
            if (model.wasPropertyExplicitlySet("hostCpuCount")) {
                this.hostCpuCount(model.getHostCpuCount());
            }
            if (model.wasPropertyExplicitlySet("items")) {
                this.items(model.getItems());
            }
            return this;
        }
    }
}

