/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOpensearchClusterRequest
extends BmcRequest<Void> {
    private String opensearchClusterId;
    private String opcRequestId;

    public String getOpensearchClusterId() {
        return this.opensearchClusterId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().opensearchClusterId(this.opensearchClusterId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opensearchClusterId=").append(String.valueOf(this.opensearchClusterId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOpensearchClusterRequest)) {
            return false;
        }
        GetOpensearchClusterRequest other = (GetOpensearchClusterRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opensearchClusterId, other.opensearchClusterId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opensearchClusterId == null ? 43 : this.opensearchClusterId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOpensearchClusterRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opensearchClusterId = null;
        private String opcRequestId = null;

        public Builder opensearchClusterId(String opensearchClusterId) {
            this.opensearchClusterId = opensearchClusterId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOpensearchClusterRequest o) {
            this.opensearchClusterId(o.getOpensearchClusterId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOpensearchClusterRequest build() {
            GetOpensearchClusterRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOpensearchClusterRequest buildWithoutInvocationCallback() {
            GetOpensearchClusterRequest request = new GetOpensearchClusterRequest();
            request.opensearchClusterId = this.opensearchClusterId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

