/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetOpensearchClusterBackupRequest
extends BmcRequest<Void> {
    private String opensearchClusterBackupId;
    private String opcRequestId;

    public String getOpensearchClusterBackupId() {
        return this.opensearchClusterBackupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().opensearchClusterBackupId(this.opensearchClusterBackupId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opensearchClusterBackupId=").append(String.valueOf(this.opensearchClusterBackupId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetOpensearchClusterBackupRequest)) {
            return false;
        }
        GetOpensearchClusterBackupRequest other = (GetOpensearchClusterBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opensearchClusterBackupId, other.opensearchClusterBackupId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opensearchClusterBackupId == null ? 43 : this.opensearchClusterBackupId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOpensearchClusterBackupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opensearchClusterBackupId = null;
        private String opcRequestId = null;

        public Builder opensearchClusterBackupId(String opensearchClusterBackupId) {
            this.opensearchClusterBackupId = opensearchClusterBackupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOpensearchClusterBackupRequest o) {
            this.opensearchClusterBackupId(o.getOpensearchClusterBackupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOpensearchClusterBackupRequest build() {
            GetOpensearchClusterBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetOpensearchClusterBackupRequest buildWithoutInvocationCallback() {
            GetOpensearchClusterBackupRequest request = new GetOpensearchClusterBackupRequest();
            request.opensearchClusterBackupId = this.opensearchClusterBackupId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

