/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.opensearch;

import com.oracle.bmc.opensearch.OpensearchCluster;
import com.oracle.bmc.opensearch.model.OpensearchCluster;
import com.oracle.bmc.opensearch.requests.GetOpensearchClusterRequest;
import com.oracle.bmc.opensearch.requests.GetWorkRequestRequest;
import com.oracle.bmc.opensearch.responses.GetOpensearchClusterResponse;
import com.oracle.bmc.opensearch.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OpensearchClusterWaiters {
    private final ExecutorService executorService;
    private final OpensearchCluster client;

    public OpensearchClusterWaiters(ExecutorService executorService, OpensearchCluster client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOpensearchClusterRequest, GetOpensearchClusterResponse> forOpensearchCluster(GetOpensearchClusterRequest request, OpensearchCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOpensearchCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOpensearchClusterRequest, GetOpensearchClusterResponse> forOpensearchCluster(GetOpensearchClusterRequest request, OpensearchCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOpensearchCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOpensearchClusterRequest, GetOpensearchClusterResponse> forOpensearchCluster(GetOpensearchClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OpensearchCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOpensearchCluster(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOpensearchClusterRequest, GetOpensearchClusterResponse> forOpensearchCluster(BmcGenericWaiter waiter, GetOpensearchClusterRequest request, OpensearchCluster.LifecycleState ... targetStates) {
        final HashSet<OpensearchCluster.LifecycleState> targetStatesSet = new HashSet<OpensearchCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOpensearchClusterRequest, GetOpensearchClusterResponse>(){

            @Override
            public GetOpensearchClusterResponse apply(GetOpensearchClusterRequest request) {
                return OpensearchClusterWaiters.this.client.getOpensearchCluster(request);
            }
        }, (Predicate)new Predicate<GetOpensearchClusterResponse>(){

            @Override
            public boolean test(GetOpensearchClusterResponse response) {
                return targetStatesSet.contains((Object)response.getOpensearchCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OpensearchCluster.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OpensearchClusterWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

