/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ons.responses;

import com.oracle.bmc.ons.model.PublishResult;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PublishMessageResponse
extends BmcResponse {
    private String opcRequestId;
    private PublishResult publishResult;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PublishResult getPublishResult() {
        return this.publishResult;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "publishResult"})
    private PublishMessageResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, PublishResult publishResult) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.publishResult = publishResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",publishResult=").append(String.valueOf((Object)this.publishResult));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishMessageResponse)) {
            return false;
        }
        PublishMessageResponse other = (PublishMessageResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.publishResult, (Object)other.publishResult);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.publishResult == null ? 43 : this.publishResult.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<PublishMessageResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private PublishResult publishResult;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder publishResult(PublishResult publishResult) {
            this.publishResult = publishResult;
            return this;
        }

        public Builder copy(PublishMessageResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.publishResult(o.getPublishResult());
            return this;
        }

        public PublishMessageResponse build() {
            return new PublishMessageResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.publishResult);
        }
    }
}

