/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListComputedUsagesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String subscriptionId;
    private Date timeFrom;
    private Date timeTo;
    private String parentProduct;
    private String computedProduct;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Date getTimeFrom() {
        return this.timeFrom;
    }

    public Date getTimeTo() {
        return this.timeTo;
    }

    public String getParentProduct() {
        return this.parentProduct;
    }

    public String getComputedProduct() {
        return this.computedProduct;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).subscriptionId(this.subscriptionId).timeFrom(this.timeFrom).timeTo(this.timeTo).parentProduct(this.parentProduct).computedProduct(this.computedProduct).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",timeFrom=").append(String.valueOf(this.timeFrom));
        sb.append(",timeTo=").append(String.valueOf(this.timeTo));
        sb.append(",parentProduct=").append(String.valueOf(this.parentProduct));
        sb.append(",computedProduct=").append(String.valueOf(this.computedProduct));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListComputedUsagesRequest)) {
            return false;
        }
        ListComputedUsagesRequest other = (ListComputedUsagesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.timeFrom, other.timeFrom) && Objects.equals(this.timeTo, other.timeTo) && Objects.equals(this.parentProduct, other.parentProduct) && Objects.equals(this.computedProduct, other.computedProduct) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.timeFrom == null ? 43 : this.timeFrom.hashCode());
        result = result * 59 + (this.timeTo == null ? 43 : this.timeTo.hashCode());
        result = result * 59 + (this.parentProduct == null ? 43 : this.parentProduct.hashCode());
        result = result * 59 + (this.computedProduct == null ? 43 : this.computedProduct.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListComputedUsagesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String subscriptionId = null;
        private Date timeFrom = null;
        private Date timeTo = null;
        private String parentProduct = null;
        private String computedProduct = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder timeFrom(Date timeFrom) {
            this.timeFrom = timeFrom;
            return this;
        }

        public Builder timeTo(Date timeTo) {
            this.timeTo = timeTo;
            return this;
        }

        public Builder parentProduct(String parentProduct) {
            this.parentProduct = parentProduct;
            return this;
        }

        public Builder computedProduct(String computedProduct) {
            this.computedProduct = computedProduct;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListComputedUsagesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.subscriptionId(o.getSubscriptionId());
            this.timeFrom(o.getTimeFrom());
            this.timeTo(o.getTimeTo());
            this.parentProduct(o.getParentProduct());
            this.computedProduct(o.getComputedProduct());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListComputedUsagesRequest build() {
            ListComputedUsagesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListComputedUsagesRequest buildWithoutInvocationCallback() {
            ListComputedUsagesRequest request = new ListComputedUsagesRequest();
            request.compartmentId = this.compartmentId;
            request.subscriptionId = this.subscriptionId;
            request.timeFrom = this.timeFrom;
            request.timeTo = this.timeTo;
            request.parentProduct = this.parentProduct;
            request.computedProduct = this.computedProduct;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        TimeOfArrival("timeOfArrival"),
        TimeMeteredOn("timeMeteredOn");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

