/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.onesubscription.model.SubscribedServiceLocation;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SubscribedServiceAddress
extends ExplicitlySetBmcModel {
    @JsonProperty(value="location")
    private final SubscribedServiceLocation location;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="phone")
    private final String phone;
    @JsonProperty(value="isBillTo")
    private final Boolean isBillTo;
    @JsonProperty(value="isShipTo")
    private final Boolean isShipTo;
    @JsonProperty(value="billSiteUseId")
    private final Long billSiteUseId;
    @JsonProperty(value="service2SiteUseId")
    private final Long service2SiteUseId;
    @JsonProperty(value="tcaCustAcctSiteId")
    private final Long tcaCustAcctSiteId;
    @JsonProperty(value="tcaPartySiteNumber")
    private final String tcaPartySiteNumber;

    @Deprecated
    @ConstructorProperties(value={"location", "name", "phone", "isBillTo", "isShipTo", "billSiteUseId", "service2SiteUseId", "tcaCustAcctSiteId", "tcaPartySiteNumber"})
    public SubscribedServiceAddress(SubscribedServiceLocation location, String name, String phone, Boolean isBillTo, Boolean isShipTo, Long billSiteUseId, Long service2SiteUseId, Long tcaCustAcctSiteId, String tcaPartySiteNumber) {
        this.location = location;
        this.name = name;
        this.phone = phone;
        this.isBillTo = isBillTo;
        this.isShipTo = isShipTo;
        this.billSiteUseId = billSiteUseId;
        this.service2SiteUseId = service2SiteUseId;
        this.tcaCustAcctSiteId = tcaCustAcctSiteId;
        this.tcaPartySiteNumber = tcaPartySiteNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public SubscribedServiceLocation getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getPhone() {
        return this.phone;
    }

    public Boolean getIsBillTo() {
        return this.isBillTo;
    }

    public Boolean getIsShipTo() {
        return this.isShipTo;
    }

    public Long getBillSiteUseId() {
        return this.billSiteUseId;
    }

    public Long getService2SiteUseId() {
        return this.service2SiteUseId;
    }

    public Long getTcaCustAcctSiteId() {
        return this.tcaCustAcctSiteId;
    }

    public String getTcaPartySiteNumber() {
        return this.tcaPartySiteNumber;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscribedServiceAddress(");
        sb.append("super=").append(super.toString());
        sb.append("location=").append(String.valueOf((Object)this.location));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", phone=").append(String.valueOf(this.phone));
        sb.append(", isBillTo=").append(String.valueOf(this.isBillTo));
        sb.append(", isShipTo=").append(String.valueOf(this.isShipTo));
        sb.append(", billSiteUseId=").append(String.valueOf(this.billSiteUseId));
        sb.append(", service2SiteUseId=").append(String.valueOf(this.service2SiteUseId));
        sb.append(", tcaCustAcctSiteId=").append(String.valueOf(this.tcaCustAcctSiteId));
        sb.append(", tcaPartySiteNumber=").append(String.valueOf(this.tcaPartySiteNumber));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscribedServiceAddress)) {
            return false;
        }
        SubscribedServiceAddress other = (SubscribedServiceAddress)((Object)o);
        return Objects.equals((Object)this.location, (Object)other.location) && Objects.equals(this.name, other.name) && Objects.equals(this.phone, other.phone) && Objects.equals(this.isBillTo, other.isBillTo) && Objects.equals(this.isShipTo, other.isShipTo) && Objects.equals(this.billSiteUseId, other.billSiteUseId) && Objects.equals(this.service2SiteUseId, other.service2SiteUseId) && Objects.equals(this.tcaCustAcctSiteId, other.tcaCustAcctSiteId) && Objects.equals(this.tcaPartySiteNumber, other.tcaPartySiteNumber) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.phone == null ? 43 : this.phone.hashCode());
        result = result * 59 + (this.isBillTo == null ? 43 : this.isBillTo.hashCode());
        result = result * 59 + (this.isShipTo == null ? 43 : this.isShipTo.hashCode());
        result = result * 59 + (this.billSiteUseId == null ? 43 : this.billSiteUseId.hashCode());
        result = result * 59 + (this.service2SiteUseId == null ? 43 : this.service2SiteUseId.hashCode());
        result = result * 59 + (this.tcaCustAcctSiteId == null ? 43 : this.tcaCustAcctSiteId.hashCode());
        result = result * 59 + (this.tcaPartySiteNumber == null ? 43 : this.tcaPartySiteNumber.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="location")
        private SubscribedServiceLocation location;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="phone")
        private String phone;
        @JsonProperty(value="isBillTo")
        private Boolean isBillTo;
        @JsonProperty(value="isShipTo")
        private Boolean isShipTo;
        @JsonProperty(value="billSiteUseId")
        private Long billSiteUseId;
        @JsonProperty(value="service2SiteUseId")
        private Long service2SiteUseId;
        @JsonProperty(value="tcaCustAcctSiteId")
        private Long tcaCustAcctSiteId;
        @JsonProperty(value="tcaPartySiteNumber")
        private String tcaPartySiteNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder location(SubscribedServiceLocation location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.__explicitlySet__.add("phone");
            return this;
        }

        public Builder isBillTo(Boolean isBillTo) {
            this.isBillTo = isBillTo;
            this.__explicitlySet__.add("isBillTo");
            return this;
        }

        public Builder isShipTo(Boolean isShipTo) {
            this.isShipTo = isShipTo;
            this.__explicitlySet__.add("isShipTo");
            return this;
        }

        public Builder billSiteUseId(Long billSiteUseId) {
            this.billSiteUseId = billSiteUseId;
            this.__explicitlySet__.add("billSiteUseId");
            return this;
        }

        public Builder service2SiteUseId(Long service2SiteUseId) {
            this.service2SiteUseId = service2SiteUseId;
            this.__explicitlySet__.add("service2SiteUseId");
            return this;
        }

        public Builder tcaCustAcctSiteId(Long tcaCustAcctSiteId) {
            this.tcaCustAcctSiteId = tcaCustAcctSiteId;
            this.__explicitlySet__.add("tcaCustAcctSiteId");
            return this;
        }

        public Builder tcaPartySiteNumber(String tcaPartySiteNumber) {
            this.tcaPartySiteNumber = tcaPartySiteNumber;
            this.__explicitlySet__.add("tcaPartySiteNumber");
            return this;
        }

        public SubscribedServiceAddress build() {
            SubscribedServiceAddress model = new SubscribedServiceAddress(this.location, this.name, this.phone, this.isBillTo, this.isShipTo, this.billSiteUseId, this.service2SiteUseId, this.tcaCustAcctSiteId, this.tcaPartySiteNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubscribedServiceAddress model) {
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("phone")) {
                this.phone(model.getPhone());
            }
            if (model.wasPropertyExplicitlySet("isBillTo")) {
                this.isBillTo(model.getIsBillTo());
            }
            if (model.wasPropertyExplicitlySet("isShipTo")) {
                this.isShipTo(model.getIsShipTo());
            }
            if (model.wasPropertyExplicitlySet("billSiteUseId")) {
                this.billSiteUseId(model.getBillSiteUseId());
            }
            if (model.wasPropertyExplicitlySet("service2SiteUseId")) {
                this.service2SiteUseId(model.getService2SiteUseId());
            }
            if (model.wasPropertyExplicitlySet("tcaCustAcctSiteId")) {
                this.tcaCustAcctSiteId(model.getTcaCustAcctSiteId());
            }
            if (model.wasPropertyExplicitlySet("tcaPartySiteNumber")) {
                this.tcaPartySiteNumber(model.getTcaPartySiteNumber());
            }
            return this;
        }
    }
}

