/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.onesubscription.model.ComputedUsageAggregation;
import com.oracle.bmc.onesubscription.model.ComputedUsageProduct;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AggregatedComputedUsageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="subscriptionId")
    private final String subscriptionId;
    @JsonProperty(value="parentSubscribedServiceId")
    private final String parentSubscribedServiceId;
    @JsonProperty(value="parentProduct")
    private final ComputedUsageProduct parentProduct;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="planNumber")
    private final String planNumber;
    @JsonProperty(value="currencyCode")
    private final String currencyCode;
    @JsonProperty(value="rateCardId")
    private final String rateCardId;
    @JsonProperty(value="pricingModel")
    private final PricingModel pricingModel;
    @JsonProperty(value="aggregatedComputedUsages")
    private final List<ComputedUsageAggregation> aggregatedComputedUsages;

    @Deprecated
    @ConstructorProperties(value={"subscriptionId", "parentSubscribedServiceId", "parentProduct", "timeStart", "timeEnd", "planNumber", "currencyCode", "rateCardId", "pricingModel", "aggregatedComputedUsages"})
    public AggregatedComputedUsageSummary(String subscriptionId, String parentSubscribedServiceId, ComputedUsageProduct parentProduct, Date timeStart, Date timeEnd, String planNumber, String currencyCode, String rateCardId, PricingModel pricingModel, List<ComputedUsageAggregation> aggregatedComputedUsages) {
        this.subscriptionId = subscriptionId;
        this.parentSubscribedServiceId = parentSubscribedServiceId;
        this.parentProduct = parentProduct;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.planNumber = planNumber;
        this.currencyCode = currencyCode;
        this.rateCardId = rateCardId;
        this.pricingModel = pricingModel;
        this.aggregatedComputedUsages = aggregatedComputedUsages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getParentSubscribedServiceId() {
        return this.parentSubscribedServiceId;
    }

    public ComputedUsageProduct getParentProduct() {
        return this.parentProduct;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getPlanNumber() {
        return this.planNumber;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getRateCardId() {
        return this.rateCardId;
    }

    public PricingModel getPricingModel() {
        return this.pricingModel;
    }

    public List<ComputedUsageAggregation> getAggregatedComputedUsages() {
        return this.aggregatedComputedUsages;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AggregatedComputedUsageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(", parentSubscribedServiceId=").append(String.valueOf(this.parentSubscribedServiceId));
        sb.append(", parentProduct=").append(String.valueOf((Object)this.parentProduct));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", planNumber=").append(String.valueOf(this.planNumber));
        sb.append(", currencyCode=").append(String.valueOf(this.currencyCode));
        sb.append(", rateCardId=").append(String.valueOf(this.rateCardId));
        sb.append(", pricingModel=").append(String.valueOf((Object)this.pricingModel));
        sb.append(", aggregatedComputedUsages=").append(String.valueOf(this.aggregatedComputedUsages));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregatedComputedUsageSummary)) {
            return false;
        }
        AggregatedComputedUsageSummary other = (AggregatedComputedUsageSummary)((Object)o);
        return Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.parentSubscribedServiceId, other.parentSubscribedServiceId) && Objects.equals((Object)this.parentProduct, (Object)other.parentProduct) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.planNumber, other.planNumber) && Objects.equals(this.currencyCode, other.currencyCode) && Objects.equals(this.rateCardId, other.rateCardId) && Objects.equals((Object)this.pricingModel, (Object)other.pricingModel) && Objects.equals(this.aggregatedComputedUsages, other.aggregatedComputedUsages) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.parentSubscribedServiceId == null ? 43 : this.parentSubscribedServiceId.hashCode());
        result = result * 59 + (this.parentProduct == null ? 43 : this.parentProduct.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.planNumber == null ? 43 : this.planNumber.hashCode());
        result = result * 59 + (this.currencyCode == null ? 43 : this.currencyCode.hashCode());
        result = result * 59 + (this.rateCardId == null ? 43 : this.rateCardId.hashCode());
        result = result * 59 + (this.pricingModel == null ? 43 : this.pricingModel.hashCode());
        result = result * 59 + (this.aggregatedComputedUsages == null ? 43 : this.aggregatedComputedUsages.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PricingModel implements BmcEnum
    {
        PayAsYouGo("PAY_AS_YOU_GO"),
        Monthly("MONTHLY"),
        Annual("ANNUAL"),
        Prepaid("PREPAID"),
        FundedAllocation("FUNDED_ALLOCATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PricingModel> map;

        private PricingModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PricingModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PricingModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PricingModel.class);
            map = new HashMap<String, PricingModel>();
            for (PricingModel v : PricingModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="subscriptionId")
        private String subscriptionId;
        @JsonProperty(value="parentSubscribedServiceId")
        private String parentSubscribedServiceId;
        @JsonProperty(value="parentProduct")
        private ComputedUsageProduct parentProduct;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="planNumber")
        private String planNumber;
        @JsonProperty(value="currencyCode")
        private String currencyCode;
        @JsonProperty(value="rateCardId")
        private String rateCardId;
        @JsonProperty(value="pricingModel")
        private PricingModel pricingModel;
        @JsonProperty(value="aggregatedComputedUsages")
        private List<ComputedUsageAggregation> aggregatedComputedUsages;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.__explicitlySet__.add("subscriptionId");
            return this;
        }

        public Builder parentSubscribedServiceId(String parentSubscribedServiceId) {
            this.parentSubscribedServiceId = parentSubscribedServiceId;
            this.__explicitlySet__.add("parentSubscribedServiceId");
            return this;
        }

        public Builder parentProduct(ComputedUsageProduct parentProduct) {
            this.parentProduct = parentProduct;
            this.__explicitlySet__.add("parentProduct");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder planNumber(String planNumber) {
            this.planNumber = planNumber;
            this.__explicitlySet__.add("planNumber");
            return this;
        }

        public Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            this.__explicitlySet__.add("currencyCode");
            return this;
        }

        public Builder rateCardId(String rateCardId) {
            this.rateCardId = rateCardId;
            this.__explicitlySet__.add("rateCardId");
            return this;
        }

        public Builder pricingModel(PricingModel pricingModel) {
            this.pricingModel = pricingModel;
            this.__explicitlySet__.add("pricingModel");
            return this;
        }

        public Builder aggregatedComputedUsages(List<ComputedUsageAggregation> aggregatedComputedUsages) {
            this.aggregatedComputedUsages = aggregatedComputedUsages;
            this.__explicitlySet__.add("aggregatedComputedUsages");
            return this;
        }

        public AggregatedComputedUsageSummary build() {
            AggregatedComputedUsageSummary model = new AggregatedComputedUsageSummary(this.subscriptionId, this.parentSubscribedServiceId, this.parentProduct, this.timeStart, this.timeEnd, this.planNumber, this.currencyCode, this.rateCardId, this.pricingModel, this.aggregatedComputedUsages);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AggregatedComputedUsageSummary model) {
            if (model.wasPropertyExplicitlySet("subscriptionId")) {
                this.subscriptionId(model.getSubscriptionId());
            }
            if (model.wasPropertyExplicitlySet("parentSubscribedServiceId")) {
                this.parentSubscribedServiceId(model.getParentSubscribedServiceId());
            }
            if (model.wasPropertyExplicitlySet("parentProduct")) {
                this.parentProduct(model.getParentProduct());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("planNumber")) {
                this.planNumber(model.getPlanNumber());
            }
            if (model.wasPropertyExplicitlySet("currencyCode")) {
                this.currencyCode(model.getCurrencyCode());
            }
            if (model.wasPropertyExplicitlySet("rateCardId")) {
                this.rateCardId(model.getRateCardId());
            }
            if (model.wasPropertyExplicitlySet("pricingModel")) {
                this.pricingModel(model.getPricingModel());
            }
            if (model.wasPropertyExplicitlySet("aggregatedComputedUsages")) {
                this.aggregatedComputedUsages(model.getAggregatedComputedUsages());
            }
            return this;
        }
    }
}

