/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.onesubscription.SubscribedService;
import com.oracle.bmc.onesubscription.model.SubscribedServiceSummary;
import com.oracle.bmc.onesubscription.requests.ListSubscribedServicesRequest;
import com.oracle.bmc.onesubscription.responses.ListSubscribedServicesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SubscribedServicePaginators {
    private final SubscribedService client;

    public SubscribedServicePaginators(SubscribedService client) {
        this.client = client;
    }

    public Iterable<ListSubscribedServicesResponse> listSubscribedServicesResponseIterator(final ListSubscribedServicesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSubscribedServicesRequest.Builder>(){

            @Override
            public ListSubscribedServicesRequest.Builder get() {
                return ListSubscribedServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscribedServicesResponse, String>(){

            @Override
            public String apply(ListSubscribedServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscribedServicesRequest.Builder>, ListSubscribedServicesRequest>(){

            @Override
            public ListSubscribedServicesRequest apply(RequestBuilderAndToken<ListSubscribedServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscribedServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscribedServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscribedServicesRequest, ListSubscribedServicesResponse>(){

            @Override
            public ListSubscribedServicesResponse apply(ListSubscribedServicesRequest request) {
                return SubscribedServicePaginators.this.client.listSubscribedServices(request);
            }
        });
    }

    public Iterable<SubscribedServiceSummary> listSubscribedServicesRecordIterator(final ListSubscribedServicesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSubscribedServicesRequest.Builder>(){

            @Override
            public ListSubscribedServicesRequest.Builder get() {
                return ListSubscribedServicesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSubscribedServicesResponse, String>(){

            @Override
            public String apply(ListSubscribedServicesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSubscribedServicesRequest.Builder>, ListSubscribedServicesRequest>(){

            @Override
            public ListSubscribedServicesRequest apply(RequestBuilderAndToken<ListSubscribedServicesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSubscribedServicesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSubscribedServicesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSubscribedServicesRequest, ListSubscribedServicesResponse>(){

            @Override
            public ListSubscribedServicesResponse apply(ListSubscribedServicesRequest request) {
                return SubscribedServicePaginators.this.client.listSubscribedServices(request);
            }
        }, (Function)new Function<ListSubscribedServicesResponse, List<SubscribedServiceSummary>>(){

            @Override
            public List<SubscribedServiceSummary> apply(ListSubscribedServicesResponse response) {
                return response.getItems();
            }
        });
    }
}

