/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.onesubscription.OrganizationSubscription;
import com.oracle.bmc.onesubscription.OrganizationSubscriptionAsyncClient;
import com.oracle.bmc.onesubscription.OrganizationSubscriptionPaginators;
import com.oracle.bmc.onesubscription.model.OrganizationSubscriptionSummary;
import com.oracle.bmc.onesubscription.requests.ListOrganizationSubscriptionsRequest;
import com.oracle.bmc.onesubscription.responses.ListOrganizationSubscriptionsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationSubscriptionClient
extends BaseSyncClient
implements OrganizationSubscription {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ORGANIZATIONSUBSCRIPTION").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OrganizationSubscriptionAsyncClient.class);
    private final OrganizationSubscriptionPaginators paginators = new OrganizationSubscriptionPaginators(this);

    private OrganizationSubscriptionClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ListOrganizationSubscriptionsResponse listOrganizationSubscriptions(ListOrganizationSubscriptionsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOrganizationSubscriptionsResponse)this.clientCall(request, ListOrganizationSubscriptionsResponse::builder).logger(LOG, "listOrganizationSubscriptions").serviceDetails("OrganizationSubscription", "ListOrganizationSubscriptions", "").method(Method.GET).requestBuilder(ListOrganizationSubscriptionsRequest::builder).basePath("/20190111").appendPathParam("organizationSubscription").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(OrganizationSubscriptionSummary.class, ListOrganizationSubscriptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListOrganizationSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListOrganizationSubscriptionsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OrganizationSubscriptionPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OrganizationSubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OrganizationSubscriptionClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OrganizationSubscriptionClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OrganizationSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OrganizationSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OrganizationSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OrganizationSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OrganizationSubscriptionClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OrganizationSubscriptionClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OrganizationSubscriptionClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OrganizationSubscriptionClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OrganizationSubscriptionClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

