/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.onesubscription.InvoiceSummaryAsync;
import com.oracle.bmc.onesubscription.model.InvoiceSummary;
import com.oracle.bmc.onesubscription.model.InvoicelineComputedUsageSummary;
import com.oracle.bmc.onesubscription.requests.ListInvoicelineComputedUsagesRequest;
import com.oracle.bmc.onesubscription.requests.ListInvoicesRequest;
import com.oracle.bmc.onesubscription.responses.ListInvoicelineComputedUsagesResponse;
import com.oracle.bmc.onesubscription.responses.ListInvoicesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceSummaryAsyncClient
extends BaseAsyncClient
implements InvoiceSummaryAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INVOICESUMMARY").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(InvoiceSummaryAsyncClient.class);

    private InvoiceSummaryAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ListInvoicelineComputedUsagesResponse> listInvoicelineComputedUsages(ListInvoicelineComputedUsagesRequest request, AsyncHandler<ListInvoicelineComputedUsagesRequest, ListInvoicelineComputedUsagesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getInvoiceLineId(), "invoiceLineId is required");
        return this.clientCall(request, ListInvoicelineComputedUsagesResponse::builder).logger(LOG, "listInvoicelineComputedUsages").serviceDetails("InvoiceSummary", "ListInvoicelineComputedUsages", "").method(Method.GET).requestBuilder(ListInvoicelineComputedUsagesRequest::builder).basePath("/20190111").appendPathParam("invoiceLineComputedUsages").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("invoiceLineId", (Object)request.getInvoiceLineId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InvoicelineComputedUsageSummary.class, ListInvoicelineComputedUsagesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInvoicelineComputedUsagesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInvoicelineComputedUsagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInvoicesResponse> listInvoices(ListInvoicesRequest request, AsyncHandler<ListInvoicesRequest, ListInvoicesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getArCustomerTransactionId(), "arCustomerTransactionId is required");
        return this.clientCall(request, ListInvoicesResponse::builder).logger(LOG, "listInvoices").serviceDetails("InvoiceSummary", "ListInvoices", "").method(Method.GET).requestBuilder(ListInvoicesRequest::builder).basePath("/20190111").appendPathParam("invoice").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("arCustomerTransactionId", (Object)request.getArCustomerTransactionId()).appendQueryParam("timeFrom", (Object)request.getTimeFrom()).appendQueryParam("timeTo", (Object)request.getTimeTo()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(InvoiceSummary.class, ListInvoicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInvoicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInvoicesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public InvoiceSummaryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)InvoiceSummaryAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(InvoiceSummaryAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)InvoiceSummaryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)InvoiceSummaryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)InvoiceSummaryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)InvoiceSummaryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public InvoiceSummaryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)InvoiceSummaryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, InvoiceSummaryAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public InvoiceSummaryAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new InvoiceSummaryAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

