/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.onesubscription.Commitment;
import com.oracle.bmc.onesubscription.model.CommitmentSummary;
import com.oracle.bmc.onesubscription.requests.ListCommitmentsRequest;
import com.oracle.bmc.onesubscription.responses.ListCommitmentsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class CommitmentPaginators {
    private final Commitment client;

    public CommitmentPaginators(Commitment client) {
        this.client = client;
    }

    public Iterable<ListCommitmentsResponse> listCommitmentsResponseIterator(final ListCommitmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCommitmentsRequest.Builder>(){

            @Override
            public ListCommitmentsRequest.Builder get() {
                return ListCommitmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCommitmentsResponse, String>(){

            @Override
            public String apply(ListCommitmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCommitmentsRequest.Builder>, ListCommitmentsRequest>(){

            @Override
            public ListCommitmentsRequest apply(RequestBuilderAndToken<ListCommitmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCommitmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCommitmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCommitmentsRequest, ListCommitmentsResponse>(){

            @Override
            public ListCommitmentsResponse apply(ListCommitmentsRequest request) {
                return CommitmentPaginators.this.client.listCommitments(request);
            }
        });
    }

    public Iterable<CommitmentSummary> listCommitmentsRecordIterator(final ListCommitmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCommitmentsRequest.Builder>(){

            @Override
            public ListCommitmentsRequest.Builder get() {
                return ListCommitmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCommitmentsResponse, String>(){

            @Override
            public String apply(ListCommitmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCommitmentsRequest.Builder>, ListCommitmentsRequest>(){

            @Override
            public ListCommitmentsRequest apply(RequestBuilderAndToken<ListCommitmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCommitmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCommitmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCommitmentsRequest, ListCommitmentsResponse>(){

            @Override
            public ListCommitmentsResponse apply(ListCommitmentsRequest request) {
                return CommitmentPaginators.this.client.listCommitments(request);
            }
        }, (Function)new Function<ListCommitmentsResponse, List<CommitmentSummary>>(){

            @Override
            public List<CommitmentSummary> apply(ListCommitmentsResponse response) {
                return response.getItems();
            }
        });
    }
}

