/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.onesubscription.CommitmentAsyncClient;
import com.oracle.bmc.onesubscription.CommitmentPaginators;
import com.oracle.bmc.onesubscription.model.Commitment;
import com.oracle.bmc.onesubscription.model.CommitmentSummary;
import com.oracle.bmc.onesubscription.requests.GetCommitmentRequest;
import com.oracle.bmc.onesubscription.requests.ListCommitmentsRequest;
import com.oracle.bmc.onesubscription.responses.GetCommitmentResponse;
import com.oracle.bmc.onesubscription.responses.ListCommitmentsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitmentClient
extends BaseSyncClient
implements com.oracle.bmc.onesubscription.Commitment {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMMITMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://identity.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(CommitmentAsyncClient.class);
    private final CommitmentPaginators paginators = new CommitmentPaginators(this);

    private CommitmentClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetCommitmentResponse getCommitment(GetCommitmentRequest request) {
        Validate.notBlank((String)request.getCommitmentId(), (String)"commitmentId must not be blank", (Object[])new Object[0]);
        return (GetCommitmentResponse)this.clientCall(request, GetCommitmentResponse::builder).logger(LOG, "getCommitment").serviceDetails("Commitment", "GetCommitment", "").method(Method.GET).requestBuilder(GetCommitmentRequest::builder).basePath("/20190111").appendPathParam("commitments").appendPathParam(request.getCommitmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Commitment.class, GetCommitmentResponse.Builder::commitment).handleResponseHeaderString("opc-request-id", GetCommitmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListCommitmentsResponse listCommitments(ListCommitmentsRequest request) {
        Objects.requireNonNull(request.getSubscribedServiceId(), "subscribedServiceId is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListCommitmentsResponse)this.clientCall(request, ListCommitmentsResponse::builder).logger(LOG, "listCommitments").serviceDetails("Commitment", "ListCommitments", "").method(Method.GET).requestBuilder(ListCommitmentsRequest::builder).basePath("/20190111").appendPathParam("commitments").appendQueryParam("subscribedServiceId", (Object)request.getSubscribedServiceId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CommitmentSummary.class, ListCommitmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListCommitmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListCommitmentsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CommitmentPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public CommitmentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)CommitmentClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CommitmentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(CommitmentClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CommitmentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)CommitmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public CommitmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)CommitmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public CommitmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)CommitmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public CommitmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)CommitmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public CommitmentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)CommitmentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, CommitmentClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public CommitmentClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new CommitmentClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

