/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.onesubscription;

import com.oracle.bmc.onesubscription.BillingSchedule;
import com.oracle.bmc.onesubscription.model.BillingScheduleSummary;
import com.oracle.bmc.onesubscription.requests.ListBillingSchedulesRequest;
import com.oracle.bmc.onesubscription.responses.ListBillingSchedulesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class BillingSchedulePaginators {
    private final BillingSchedule client;

    public BillingSchedulePaginators(BillingSchedule client) {
        this.client = client;
    }

    public Iterable<ListBillingSchedulesResponse> listBillingSchedulesResponseIterator(final ListBillingSchedulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBillingSchedulesRequest.Builder>(){

            @Override
            public ListBillingSchedulesRequest.Builder get() {
                return ListBillingSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBillingSchedulesResponse, String>(){

            @Override
            public String apply(ListBillingSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBillingSchedulesRequest.Builder>, ListBillingSchedulesRequest>(){

            @Override
            public ListBillingSchedulesRequest apply(RequestBuilderAndToken<ListBillingSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBillingSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBillingSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBillingSchedulesRequest, ListBillingSchedulesResponse>(){

            @Override
            public ListBillingSchedulesResponse apply(ListBillingSchedulesRequest request) {
                return BillingSchedulePaginators.this.client.listBillingSchedules(request);
            }
        });
    }

    public Iterable<BillingScheduleSummary> listBillingSchedulesRecordIterator(final ListBillingSchedulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBillingSchedulesRequest.Builder>(){

            @Override
            public ListBillingSchedulesRequest.Builder get() {
                return ListBillingSchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBillingSchedulesResponse, String>(){

            @Override
            public String apply(ListBillingSchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBillingSchedulesRequest.Builder>, ListBillingSchedulesRequest>(){

            @Override
            public ListBillingSchedulesRequest apply(RequestBuilderAndToken<ListBillingSchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBillingSchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBillingSchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBillingSchedulesRequest, ListBillingSchedulesResponse>(){

            @Override
            public ListBillingSchedulesResponse apply(ListBillingSchedulesRequest request) {
                return BillingSchedulePaginators.this.client.listBillingSchedules(request);
            }
        }, (Function)new Function<ListBillingSchedulesResponse, List<BillingScheduleSummary>>(){

            @Override
            public List<BillingScheduleSummary> apply(ListBillingSchedulesResponse response) {
                return response.getItems();
            }
        });
    }
}

