/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.responses;

import com.oracle.bmc.oda.model.PackageItem;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetPackageResponse
extends BmcResponse {
    private String opcRequestId;
    private PackageItem packageItem;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PackageItem getPackageItem() {
        return this.packageItem;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "packageItem"})
    private GetPackageResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, PackageItem packageItem) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.packageItem = packageItem;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",packageItem=").append(String.valueOf((Object)this.packageItem));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPackageResponse)) {
            return false;
        }
        GetPackageResponse other = (GetPackageResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.packageItem, (Object)other.packageItem);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.packageItem == null ? 43 : this.packageItem.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetPackageResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private PackageItem packageItem;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder packageItem(PackageItem packageItem) {
            this.packageItem = packageItem;
            return this;
        }

        public Builder copy(GetPackageResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.packageItem(o.getPackageItem());
            return this;
        }

        public GetPackageResponse build() {
            return new GetPackageResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.packageItem);
        }
    }
}

