/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.oda.model.ExportDigitalAssistantDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ExportDigitalAssistantRequest
extends BmcRequest<ExportDigitalAssistantDetails> {
    private String odaInstanceId;
    private String digitalAssistantId;
    private ExportDigitalAssistantDetails exportDigitalAssistantDetails;
    private String opcRequestId;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getDigitalAssistantId() {
        return this.digitalAssistantId;
    }

    public ExportDigitalAssistantDetails getExportDigitalAssistantDetails() {
        return this.exportDigitalAssistantDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ExportDigitalAssistantDetails getBody$() {
        return this.exportDigitalAssistantDetails;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).digitalAssistantId(this.digitalAssistantId).exportDigitalAssistantDetails(this.exportDigitalAssistantDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",digitalAssistantId=").append(String.valueOf(this.digitalAssistantId));
        sb.append(",exportDigitalAssistantDetails=").append(String.valueOf((Object)this.exportDigitalAssistantDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportDigitalAssistantRequest)) {
            return false;
        }
        ExportDigitalAssistantRequest other = (ExportDigitalAssistantRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals(this.digitalAssistantId, other.digitalAssistantId) && Objects.equals((Object)this.exportDigitalAssistantDetails, (Object)other.exportDigitalAssistantDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.digitalAssistantId == null ? 43 : this.digitalAssistantId.hashCode());
        result = result * 59 + (this.exportDigitalAssistantDetails == null ? 43 : this.exportDigitalAssistantDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ExportDigitalAssistantRequest, ExportDigitalAssistantDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private String digitalAssistantId = null;
        private ExportDigitalAssistantDetails exportDigitalAssistantDetails = null;
        private String opcRequestId = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder digitalAssistantId(String digitalAssistantId) {
            this.digitalAssistantId = digitalAssistantId;
            return this;
        }

        public Builder exportDigitalAssistantDetails(ExportDigitalAssistantDetails exportDigitalAssistantDetails) {
            this.exportDigitalAssistantDetails = exportDigitalAssistantDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExportDigitalAssistantRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.digitalAssistantId(o.getDigitalAssistantId());
            this.exportDigitalAssistantDetails(o.getExportDigitalAssistantDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExportDigitalAssistantRequest build() {
            ExportDigitalAssistantRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExportDigitalAssistantDetails body) {
            this.exportDigitalAssistantDetails(body);
            return this;
        }

        public ExportDigitalAssistantRequest buildWithoutInvocationCallback() {
            ExportDigitalAssistantRequest request = new ExportDigitalAssistantRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.digitalAssistantId = this.digitalAssistantId;
            request.exportDigitalAssistantDetails = this.exportDigitalAssistantDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

