/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.oda.model.CreateAuthenticationProviderDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateAuthenticationProviderRequest
extends BmcRequest<CreateAuthenticationProviderDetails> {
    private String odaInstanceId;
    private CreateAuthenticationProviderDetails createAuthenticationProviderDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public CreateAuthenticationProviderDetails getCreateAuthenticationProviderDetails() {
        return this.createAuthenticationProviderDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateAuthenticationProviderDetails getBody$() {
        return this.createAuthenticationProviderDetails;
    }

    public Builder toBuilder() {
        return new Builder().odaInstanceId(this.odaInstanceId).createAuthenticationProviderDetails(this.createAuthenticationProviderDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",odaInstanceId=").append(String.valueOf(this.odaInstanceId));
        sb.append(",createAuthenticationProviderDetails=").append(String.valueOf((Object)this.createAuthenticationProviderDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAuthenticationProviderRequest)) {
            return false;
        }
        CreateAuthenticationProviderRequest other = (CreateAuthenticationProviderRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.odaInstanceId, other.odaInstanceId) && Objects.equals((Object)this.createAuthenticationProviderDetails, (Object)other.createAuthenticationProviderDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.odaInstanceId == null ? 43 : this.odaInstanceId.hashCode());
        result = result * 59 + (this.createAuthenticationProviderDetails == null ? 43 : this.createAuthenticationProviderDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateAuthenticationProviderRequest, CreateAuthenticationProviderDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String odaInstanceId = null;
        private CreateAuthenticationProviderDetails createAuthenticationProviderDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder createAuthenticationProviderDetails(CreateAuthenticationProviderDetails createAuthenticationProviderDetails) {
            this.createAuthenticationProviderDetails = createAuthenticationProviderDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateAuthenticationProviderRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.createAuthenticationProviderDetails(o.getCreateAuthenticationProviderDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateAuthenticationProviderRequest build() {
            CreateAuthenticationProviderRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateAuthenticationProviderDetails body) {
            this.createAuthenticationProviderDetails(body);
            return this;
        }

        public CreateAuthenticationProviderRequest buildWithoutInvocationCallback() {
            CreateAuthenticationProviderRequest request = new CreateAuthenticationProviderRequest();
            request.odaInstanceId = this.odaInstanceId;
            request.createAuthenticationProviderDetails = this.createAuthenticationProviderDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

