/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestResource
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceAction")
    private final ResourceAction resourceAction;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusMessage")
    private final String statusMessage;
    @JsonProperty(value="resourceUri")
    private final String resourceUri;

    @Deprecated
    @ConstructorProperties(value={"resourceAction", "resourceType", "resourceId", "status", "statusMessage", "resourceUri"})
    public WorkRequestResource(ResourceAction resourceAction, String resourceType, String resourceId, Status status, String statusMessage, String resourceUri) {
        this.resourceAction = resourceAction;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.status = status;
        this.statusMessage = statusMessage;
        this.resourceUri = resourceUri;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ResourceAction getResourceAction() {
        return this.resourceAction;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestResource(");
        sb.append("super=").append(super.toString());
        sb.append("resourceAction=").append(String.valueOf((Object)this.resourceAction));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", statusMessage=").append(String.valueOf(this.statusMessage));
        sb.append(", resourceUri=").append(String.valueOf(this.resourceUri));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestResource)) {
            return false;
        }
        WorkRequestResource other = (WorkRequestResource)((Object)o);
        return Objects.equals((Object)this.resourceAction, (Object)other.resourceAction) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.statusMessage, other.statusMessage) && Objects.equals(this.resourceUri, other.resourceUri) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceAction == null ? 43 : this.resourceAction.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.statusMessage == null ? 43 : this.statusMessage.hashCode());
        result = result * 59 + (this.resourceUri == null ? 43 : this.resourceUri.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceAction implements BmcEnum
    {
        Create("CREATE"),
        Delete("DELETE"),
        Purge("PURGE"),
        Recover("RECOVER"),
        Stop("STOP"),
        Start("START"),
        ChangeCompartment("CHANGE_COMPARTMENT"),
        ChangeCustEncKey("CHANGE_CUST_ENC_KEY"),
        DeactCustEncKey("DEACT_CUST_ENC_KEY"),
        CreateAssociation("CREATE_ASSOCIATION"),
        DeleteAssociation("DELETE_ASSOCIATION"),
        UpdateEntitlementsForCacct("UPDATE_ENTITLEMENTS_FOR_CACCT"),
        CreateOdaInstanceAttachment("CREATE_ODA_INSTANCE_ATTACHMENT"),
        UpdateOdaInstanceAttachment("UPDATE_ODA_INSTANCE_ATTACHMENT"),
        DeleteOdaInstanceAttachment("DELETE_ODA_INSTANCE_ATTACHMENT"),
        CreateImportedPackage("CREATE_IMPORTED_PACKAGE"),
        UpdateImportedPackage("UPDATE_IMPORTED_PACKAGE"),
        DeleteImportedPackage("DELETE_IMPORTED_PACKAGE"),
        Export("EXPORT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceAction> map;

        private ResourceAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceAction.class);
            map = new HashMap<String, ResourceAction>();
            for (ResourceAction v : ResourceAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceAction")
        private ResourceAction resourceAction;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusMessage")
        private String statusMessage;
        @JsonProperty(value="resourceUri")
        private String resourceUri;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceAction(ResourceAction resourceAction) {
            this.resourceAction = resourceAction;
            this.__explicitlySet__.add("resourceAction");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            this.__explicitlySet__.add("statusMessage");
            return this;
        }

        public Builder resourceUri(String resourceUri) {
            this.resourceUri = resourceUri;
            this.__explicitlySet__.add("resourceUri");
            return this;
        }

        public WorkRequestResource build() {
            WorkRequestResource model = new WorkRequestResource(this.resourceAction, this.resourceType, this.resourceId, this.status, this.statusMessage, this.resourceUri);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestResource model) {
            if (model.wasPropertyExplicitlySet("resourceAction")) {
                this.resourceAction(model.getResourceAction());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("statusMessage")) {
                this.statusMessage(model.getStatusMessage());
            }
            if (model.wasPropertyExplicitlySet("resourceUri")) {
                this.resourceUri(model.getResourceUri());
            }
            return this;
        }
    }
}

