/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class StorageLocation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="regionId")
    private final String regionId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="namespaceName")
    private final String namespaceName;
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="objectName")
    private final String objectName;

    @Deprecated
    @ConstructorProperties(value={"regionId", "compartmentId", "namespaceName", "bucketName", "objectName"})
    public StorageLocation(String regionId, String compartmentId, String namespaceName, String bucketName, String objectName) {
        this.regionId = regionId;
        this.compartmentId = compartmentId;
        this.namespaceName = namespaceName;
        this.bucketName = bucketName;
        this.objectName = objectName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StorageLocation(");
        sb.append("super=").append(super.toString());
        sb.append("regionId=").append(String.valueOf(this.regionId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(", bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StorageLocation)) {
            return false;
        }
        StorageLocation other = (StorageLocation)((Object)o);
        return Objects.equals(this.regionId, other.regionId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.objectName, other.objectName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.regionId == null ? 43 : this.regionId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="regionId")
        private String regionId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="namespaceName")
        private String namespaceName;
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder regionId(String regionId) {
            this.regionId = regionId;
            this.__explicitlySet__.add("regionId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            this.__explicitlySet__.add("namespaceName");
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public StorageLocation build() {
            StorageLocation model = new StorageLocation(this.regionId, this.compartmentId, this.namespaceName, this.bucketName, this.objectName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StorageLocation model) {
            if (model.wasPropertyExplicitlySet("regionId")) {
                this.regionId(model.getRegionId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("namespaceName")) {
                this.namespaceName(model.getNamespaceName());
            }
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            return this;
        }
    }
}

