/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.oda.model.MetadataProperty;
import com.oracle.bmc.oda.model.ResourceTypeMetadata;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PackageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="publisherId")
    private final String publisherId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="timePublished")
    private final Date timePublished;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="resourceTypes")
    private final List<String> resourceTypes;
    @JsonProperty(value="resourceTypesMetadata")
    private final List<ResourceTypeMetadata> resourceTypesMetadata;
    @JsonProperty(value="publisherMetadata")
    private final List<MetadataProperty> publisherMetadata;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "publisherId", "name", "displayName", "version", "timePublished", "description", "resourceTypes", "resourceTypesMetadata", "publisherMetadata", "freeformTags", "definedTags"})
    public PackageSummary(String id, String publisherId, String name, String displayName, String version, Date timePublished, String description, List<String> resourceTypes, List<ResourceTypeMetadata> resourceTypesMetadata, List<MetadataProperty> publisherMetadata, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.publisherId = publisherId;
        this.name = name;
        this.displayName = displayName;
        this.version = version;
        this.timePublished = timePublished;
        this.description = description;
        this.resourceTypes = resourceTypes;
        this.resourceTypesMetadata = resourceTypesMetadata;
        this.publisherMetadata = publisherMetadata;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getTimePublished() {
        return this.timePublished;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public List<ResourceTypeMetadata> getResourceTypesMetadata() {
        return this.resourceTypesMetadata;
    }

    public List<MetadataProperty> getPublisherMetadata() {
        return this.publisherMetadata;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PackageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", publisherId=").append(String.valueOf(this.publisherId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", timePublished=").append(String.valueOf(this.timePublished));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", resourceTypes=").append(String.valueOf(this.resourceTypes));
        sb.append(", resourceTypesMetadata=").append(String.valueOf(this.resourceTypesMetadata));
        sb.append(", publisherMetadata=").append(String.valueOf(this.publisherMetadata));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageSummary)) {
            return false;
        }
        PackageSummary other = (PackageSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.publisherId, other.publisherId) && Objects.equals(this.name, other.name) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.version, other.version) && Objects.equals(this.timePublished, other.timePublished) && Objects.equals(this.description, other.description) && Objects.equals(this.resourceTypes, other.resourceTypes) && Objects.equals(this.resourceTypesMetadata, other.resourceTypesMetadata) && Objects.equals(this.publisherMetadata, other.publisherMetadata) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.publisherId == null ? 43 : this.publisherId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.timePublished == null ? 43 : this.timePublished.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.resourceTypes == null ? 43 : this.resourceTypes.hashCode());
        result = result * 59 + (this.resourceTypesMetadata == null ? 43 : this.resourceTypesMetadata.hashCode());
        result = result * 59 + (this.publisherMetadata == null ? 43 : this.publisherMetadata.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="publisherId")
        private String publisherId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="timePublished")
        private Date timePublished;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="resourceTypes")
        private List<String> resourceTypes;
        @JsonProperty(value="resourceTypesMetadata")
        private List<ResourceTypeMetadata> resourceTypesMetadata;
        @JsonProperty(value="publisherMetadata")
        private List<MetadataProperty> publisherMetadata;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            this.__explicitlySet__.add("publisherId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder timePublished(Date timePublished) {
            this.timePublished = timePublished;
            this.__explicitlySet__.add("timePublished");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder resourceTypes(List<String> resourceTypes) {
            this.resourceTypes = resourceTypes;
            this.__explicitlySet__.add("resourceTypes");
            return this;
        }

        public Builder resourceTypesMetadata(List<ResourceTypeMetadata> resourceTypesMetadata) {
            this.resourceTypesMetadata = resourceTypesMetadata;
            this.__explicitlySet__.add("resourceTypesMetadata");
            return this;
        }

        public Builder publisherMetadata(List<MetadataProperty> publisherMetadata) {
            this.publisherMetadata = publisherMetadata;
            this.__explicitlySet__.add("publisherMetadata");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public PackageSummary build() {
            PackageSummary model = new PackageSummary(this.id, this.publisherId, this.name, this.displayName, this.version, this.timePublished, this.description, this.resourceTypes, this.resourceTypesMetadata, this.publisherMetadata, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PackageSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("publisherId")) {
                this.publisherId(model.getPublisherId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("timePublished")) {
                this.timePublished(model.getTimePublished());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("resourceTypes")) {
                this.resourceTypes(model.getResourceTypes());
            }
            if (model.wasPropertyExplicitlySet("resourceTypesMetadata")) {
                this.resourceTypesMetadata(model.getResourceTypesMetadata());
            }
            if (model.wasPropertyExplicitlySet("publisherMetadata")) {
                this.publisherMetadata(model.getPublisherMetadata());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

