/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.oda.model.OdaInstanceAttachment;
import com.oracle.bmc.oda.model.OdaInstanceOwner;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OdaInstanceAttachmentSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="attachToId")
    private final String attachToId;
    @JsonProperty(value="attachmentType")
    private final AttachmentType attachmentType;
    @JsonProperty(value="attachmentMetadata")
    private final String attachmentMetadata;
    @JsonProperty(value="restrictedOperations")
    private final List<String> restrictedOperations;
    @JsonProperty(value="owner")
    private final OdaInstanceOwner owner;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastUpdate")
    private final Date timeLastUpdate;
    @JsonProperty(value="lifecycleState")
    private final OdaInstanceAttachment.LifecycleState lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "instanceId", "attachToId", "attachmentType", "attachmentMetadata", "restrictedOperations", "owner", "timeCreated", "timeLastUpdate", "lifecycleState", "freeformTags", "definedTags"})
    public OdaInstanceAttachmentSummary(String id, String instanceId, String attachToId, AttachmentType attachmentType, String attachmentMetadata, List<String> restrictedOperations, OdaInstanceOwner owner, Date timeCreated, Date timeLastUpdate, OdaInstanceAttachment.LifecycleState lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.instanceId = instanceId;
        this.attachToId = attachToId;
        this.attachmentType = attachmentType;
        this.attachmentMetadata = attachmentMetadata;
        this.restrictedOperations = restrictedOperations;
        this.owner = owner;
        this.timeCreated = timeCreated;
        this.timeLastUpdate = timeLastUpdate;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getAttachToId() {
        return this.attachToId;
    }

    public AttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public String getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public List<String> getRestrictedOperations() {
        return this.restrictedOperations;
    }

    public OdaInstanceOwner getOwner() {
        return this.owner;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastUpdate() {
        return this.timeLastUpdate;
    }

    public OdaInstanceAttachment.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OdaInstanceAttachmentSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", attachToId=").append(String.valueOf(this.attachToId));
        sb.append(", attachmentType=").append(String.valueOf((Object)this.attachmentType));
        sb.append(", attachmentMetadata=").append(String.valueOf(this.attachmentMetadata));
        sb.append(", restrictedOperations=").append(String.valueOf(this.restrictedOperations));
        sb.append(", owner=").append(String.valueOf((Object)this.owner));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastUpdate=").append(String.valueOf(this.timeLastUpdate));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OdaInstanceAttachmentSummary)) {
            return false;
        }
        OdaInstanceAttachmentSummary other = (OdaInstanceAttachmentSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.attachToId, other.attachToId) && Objects.equals((Object)this.attachmentType, (Object)other.attachmentType) && Objects.equals(this.attachmentMetadata, other.attachmentMetadata) && Objects.equals(this.restrictedOperations, other.restrictedOperations) && Objects.equals((Object)this.owner, (Object)other.owner) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastUpdate, other.timeLastUpdate) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.attachToId == null ? 43 : this.attachToId.hashCode());
        result = result * 59 + (this.attachmentType == null ? 43 : this.attachmentType.hashCode());
        result = result * 59 + (this.attachmentMetadata == null ? 43 : this.attachmentMetadata.hashCode());
        result = result * 59 + (this.restrictedOperations == null ? 43 : this.restrictedOperations.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastUpdate == null ? 43 : this.timeLastUpdate.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AttachmentType implements BmcEnum
    {
        Fusion("FUSION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AttachmentType> map;

        private AttachmentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttachmentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AttachmentType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AttachmentType.class);
            map = new HashMap<String, AttachmentType>();
            for (AttachmentType v : AttachmentType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="attachToId")
        private String attachToId;
        @JsonProperty(value="attachmentType")
        private AttachmentType attachmentType;
        @JsonProperty(value="attachmentMetadata")
        private String attachmentMetadata;
        @JsonProperty(value="restrictedOperations")
        private List<String> restrictedOperations;
        @JsonProperty(value="owner")
        private OdaInstanceOwner owner;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastUpdate")
        private Date timeLastUpdate;
        @JsonProperty(value="lifecycleState")
        private OdaInstanceAttachment.LifecycleState lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder attachToId(String attachToId) {
            this.attachToId = attachToId;
            this.__explicitlySet__.add("attachToId");
            return this;
        }

        public Builder attachmentType(AttachmentType attachmentType) {
            this.attachmentType = attachmentType;
            this.__explicitlySet__.add("attachmentType");
            return this;
        }

        public Builder attachmentMetadata(String attachmentMetadata) {
            this.attachmentMetadata = attachmentMetadata;
            this.__explicitlySet__.add("attachmentMetadata");
            return this;
        }

        public Builder restrictedOperations(List<String> restrictedOperations) {
            this.restrictedOperations = restrictedOperations;
            this.__explicitlySet__.add("restrictedOperations");
            return this;
        }

        public Builder owner(OdaInstanceOwner owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastUpdate(Date timeLastUpdate) {
            this.timeLastUpdate = timeLastUpdate;
            this.__explicitlySet__.add("timeLastUpdate");
            return this;
        }

        public Builder lifecycleState(OdaInstanceAttachment.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public OdaInstanceAttachmentSummary build() {
            OdaInstanceAttachmentSummary model = new OdaInstanceAttachmentSummary(this.id, this.instanceId, this.attachToId, this.attachmentType, this.attachmentMetadata, this.restrictedOperations, this.owner, this.timeCreated, this.timeLastUpdate, this.lifecycleState, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OdaInstanceAttachmentSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("attachToId")) {
                this.attachToId(model.getAttachToId());
            }
            if (model.wasPropertyExplicitlySet("attachmentType")) {
                this.attachmentType(model.getAttachmentType());
            }
            if (model.wasPropertyExplicitlySet("attachmentMetadata")) {
                this.attachmentMetadata(model.getAttachmentMetadata());
            }
            if (model.wasPropertyExplicitlySet("restrictedOperations")) {
                this.restrictedOperations(model.getRestrictedOperations());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastUpdate")) {
                this.timeLastUpdate(model.getTimeLastUpdate());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

