/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.oda.model.RestrictedOperation;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OdaInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="shapeName")
    private final ShapeName shapeName;
    @JsonProperty(value="webAppUrl")
    private final String webAppUrl;
    @JsonProperty(value="connectorUrl")
    private final String connectorUrl;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleSubState")
    private final LifecycleSubState lifecycleSubState;
    @JsonProperty(value="stateMessage")
    private final String stateMessage;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="isRoleBasedAccess")
    private final Boolean isRoleBasedAccess;
    @JsonProperty(value="identityDomain")
    private final String identityDomain;
    @JsonProperty(value="identityAppGuid")
    private final String identityAppGuid;
    @JsonProperty(value="identityAppConsoleUrl")
    private final String identityAppConsoleUrl;
    @JsonProperty(value="importedPackageNames")
    private final List<String> importedPackageNames;
    @JsonProperty(value="importedPackageIds")
    private final List<String> importedPackageIds;
    @JsonProperty(value="attachmentTypes")
    private final List<String> attachmentTypes;
    @JsonProperty(value="attachmentIds")
    private final List<String> attachmentIds;
    @JsonProperty(value="restrictedOperations")
    private final List<RestrictedOperation> restrictedOperations;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "shapeName", "webAppUrl", "connectorUrl", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleSubState", "stateMessage", "freeformTags", "definedTags", "isRoleBasedAccess", "identityDomain", "identityAppGuid", "identityAppConsoleUrl", "importedPackageNames", "importedPackageIds", "attachmentTypes", "attachmentIds", "restrictedOperations"})
    public OdaInstance(String id, String displayName, String description, String compartmentId, ShapeName shapeName, String webAppUrl, String connectorUrl, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, LifecycleSubState lifecycleSubState, String stateMessage, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Boolean isRoleBasedAccess, String identityDomain, String identityAppGuid, String identityAppConsoleUrl, List<String> importedPackageNames, List<String> importedPackageIds, List<String> attachmentTypes, List<String> attachmentIds, List<RestrictedOperation> restrictedOperations) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.shapeName = shapeName;
        this.webAppUrl = webAppUrl;
        this.connectorUrl = connectorUrl;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleSubState = lifecycleSubState;
        this.stateMessage = stateMessage;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.isRoleBasedAccess = isRoleBasedAccess;
        this.identityDomain = identityDomain;
        this.identityAppGuid = identityAppGuid;
        this.identityAppConsoleUrl = identityAppConsoleUrl;
        this.importedPackageNames = importedPackageNames;
        this.importedPackageIds = importedPackageIds;
        this.attachmentTypes = attachmentTypes;
        this.attachmentIds = attachmentIds;
        this.restrictedOperations = restrictedOperations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ShapeName getShapeName() {
        return this.shapeName;
    }

    public String getWebAppUrl() {
        return this.webAppUrl;
    }

    public String getConnectorUrl() {
        return this.connectorUrl;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public LifecycleSubState getLifecycleSubState() {
        return this.lifecycleSubState;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Boolean getIsRoleBasedAccess() {
        return this.isRoleBasedAccess;
    }

    public String getIdentityDomain() {
        return this.identityDomain;
    }

    public String getIdentityAppGuid() {
        return this.identityAppGuid;
    }

    public String getIdentityAppConsoleUrl() {
        return this.identityAppConsoleUrl;
    }

    public List<String> getImportedPackageNames() {
        return this.importedPackageNames;
    }

    public List<String> getImportedPackageIds() {
        return this.importedPackageIds;
    }

    public List<String> getAttachmentTypes() {
        return this.attachmentTypes;
    }

    public List<String> getAttachmentIds() {
        return this.attachmentIds;
    }

    public List<RestrictedOperation> getRestrictedOperations() {
        return this.restrictedOperations;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OdaInstance(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", shapeName=").append(String.valueOf((Object)this.shapeName));
        sb.append(", webAppUrl=").append(String.valueOf(this.webAppUrl));
        sb.append(", connectorUrl=").append(String.valueOf(this.connectorUrl));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleSubState=").append(String.valueOf((Object)this.lifecycleSubState));
        sb.append(", stateMessage=").append(String.valueOf(this.stateMessage));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", isRoleBasedAccess=").append(String.valueOf(this.isRoleBasedAccess));
        sb.append(", identityDomain=").append(String.valueOf(this.identityDomain));
        sb.append(", identityAppGuid=").append(String.valueOf(this.identityAppGuid));
        sb.append(", identityAppConsoleUrl=").append(String.valueOf(this.identityAppConsoleUrl));
        sb.append(", importedPackageNames=").append(String.valueOf(this.importedPackageNames));
        sb.append(", importedPackageIds=").append(String.valueOf(this.importedPackageIds));
        sb.append(", attachmentTypes=").append(String.valueOf(this.attachmentTypes));
        sb.append(", attachmentIds=").append(String.valueOf(this.attachmentIds));
        sb.append(", restrictedOperations=").append(String.valueOf(this.restrictedOperations));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OdaInstance)) {
            return false;
        }
        OdaInstance other = (OdaInstance)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.shapeName, (Object)other.shapeName) && Objects.equals(this.webAppUrl, other.webAppUrl) && Objects.equals(this.connectorUrl, other.connectorUrl) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifecycleSubState, (Object)other.lifecycleSubState) && Objects.equals(this.stateMessage, other.stateMessage) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.isRoleBasedAccess, other.isRoleBasedAccess) && Objects.equals(this.identityDomain, other.identityDomain) && Objects.equals(this.identityAppGuid, other.identityAppGuid) && Objects.equals(this.identityAppConsoleUrl, other.identityAppConsoleUrl) && Objects.equals(this.importedPackageNames, other.importedPackageNames) && Objects.equals(this.importedPackageIds, other.importedPackageIds) && Objects.equals(this.attachmentTypes, other.attachmentTypes) && Objects.equals(this.attachmentIds, other.attachmentIds) && Objects.equals(this.restrictedOperations, other.restrictedOperations) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.webAppUrl == null ? 43 : this.webAppUrl.hashCode());
        result = result * 59 + (this.connectorUrl == null ? 43 : this.connectorUrl.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleSubState == null ? 43 : this.lifecycleSubState.hashCode());
        result = result * 59 + (this.stateMessage == null ? 43 : this.stateMessage.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.isRoleBasedAccess == null ? 43 : this.isRoleBasedAccess.hashCode());
        result = result * 59 + (this.identityDomain == null ? 43 : this.identityDomain.hashCode());
        result = result * 59 + (this.identityAppGuid == null ? 43 : this.identityAppGuid.hashCode());
        result = result * 59 + (this.identityAppConsoleUrl == null ? 43 : this.identityAppConsoleUrl.hashCode());
        result = result * 59 + (this.importedPackageNames == null ? 43 : this.importedPackageNames.hashCode());
        result = result * 59 + (this.importedPackageIds == null ? 43 : this.importedPackageIds.hashCode());
        result = result * 59 + (this.attachmentTypes == null ? 43 : this.attachmentTypes.hashCode());
        result = result * 59 + (this.attachmentIds == null ? 43 : this.attachmentIds.hashCode());
        result = result * 59 + (this.restrictedOperations == null ? 43 : this.restrictedOperations.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleSubState implements BmcEnum
    {
        Creating("CREATING"),
        Starting("STARTING"),
        Stopping("STOPPING"),
        ChangingCompartment("CHANGING_COMPARTMENT"),
        ActivatingCustomerEncryptionKey("ACTIVATING_CUSTOMER_ENCRYPTION_KEY"),
        UpdatingCustomerEncryptionKey("UPDATING_CUSTOMER_ENCRYPTION_KEY"),
        DeactivatingCustomerEncryptionKey("DEACTIVATING_CUSTOMER_ENCRYPTION_KEY"),
        Deleting("DELETING"),
        DeletePending("DELETE_PENDING"),
        Recovering("RECOVERING"),
        Updating("UPDATING"),
        Purging("PURGING"),
        Queued("QUEUED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleSubState> map;

        private LifecycleSubState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleSubState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleSubState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleSubState.class);
            map = new HashMap<String, LifecycleSubState>();
            for (LifecycleSubState v : LifecycleSubState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ShapeName implements BmcEnum
    {
        Development("DEVELOPMENT"),
        Production("PRODUCTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ShapeName> map;

        private ShapeName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ShapeName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ShapeName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ShapeName.class);
            map = new HashMap<String, ShapeName>();
            for (ShapeName v : ShapeName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="shapeName")
        private ShapeName shapeName;
        @JsonProperty(value="webAppUrl")
        private String webAppUrl;
        @JsonProperty(value="connectorUrl")
        private String connectorUrl;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleSubState")
        private LifecycleSubState lifecycleSubState;
        @JsonProperty(value="stateMessage")
        private String stateMessage;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="isRoleBasedAccess")
        private Boolean isRoleBasedAccess;
        @JsonProperty(value="identityDomain")
        private String identityDomain;
        @JsonProperty(value="identityAppGuid")
        private String identityAppGuid;
        @JsonProperty(value="identityAppConsoleUrl")
        private String identityAppConsoleUrl;
        @JsonProperty(value="importedPackageNames")
        private List<String> importedPackageNames;
        @JsonProperty(value="importedPackageIds")
        private List<String> importedPackageIds;
        @JsonProperty(value="attachmentTypes")
        private List<String> attachmentTypes;
        @JsonProperty(value="attachmentIds")
        private List<String> attachmentIds;
        @JsonProperty(value="restrictedOperations")
        private List<RestrictedOperation> restrictedOperations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder shapeName(ShapeName shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder webAppUrl(String webAppUrl) {
            this.webAppUrl = webAppUrl;
            this.__explicitlySet__.add("webAppUrl");
            return this;
        }

        public Builder connectorUrl(String connectorUrl) {
            this.connectorUrl = connectorUrl;
            this.__explicitlySet__.add("connectorUrl");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleSubState(LifecycleSubState lifecycleSubState) {
            this.lifecycleSubState = lifecycleSubState;
            this.__explicitlySet__.add("lifecycleSubState");
            return this;
        }

        public Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            this.__explicitlySet__.add("stateMessage");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder isRoleBasedAccess(Boolean isRoleBasedAccess) {
            this.isRoleBasedAccess = isRoleBasedAccess;
            this.__explicitlySet__.add("isRoleBasedAccess");
            return this;
        }

        public Builder identityDomain(String identityDomain) {
            this.identityDomain = identityDomain;
            this.__explicitlySet__.add("identityDomain");
            return this;
        }

        public Builder identityAppGuid(String identityAppGuid) {
            this.identityAppGuid = identityAppGuid;
            this.__explicitlySet__.add("identityAppGuid");
            return this;
        }

        public Builder identityAppConsoleUrl(String identityAppConsoleUrl) {
            this.identityAppConsoleUrl = identityAppConsoleUrl;
            this.__explicitlySet__.add("identityAppConsoleUrl");
            return this;
        }

        public Builder importedPackageNames(List<String> importedPackageNames) {
            this.importedPackageNames = importedPackageNames;
            this.__explicitlySet__.add("importedPackageNames");
            return this;
        }

        public Builder importedPackageIds(List<String> importedPackageIds) {
            this.importedPackageIds = importedPackageIds;
            this.__explicitlySet__.add("importedPackageIds");
            return this;
        }

        public Builder attachmentTypes(List<String> attachmentTypes) {
            this.attachmentTypes = attachmentTypes;
            this.__explicitlySet__.add("attachmentTypes");
            return this;
        }

        public Builder attachmentIds(List<String> attachmentIds) {
            this.attachmentIds = attachmentIds;
            this.__explicitlySet__.add("attachmentIds");
            return this;
        }

        public Builder restrictedOperations(List<RestrictedOperation> restrictedOperations) {
            this.restrictedOperations = restrictedOperations;
            this.__explicitlySet__.add("restrictedOperations");
            return this;
        }

        public OdaInstance build() {
            OdaInstance model = new OdaInstance(this.id, this.displayName, this.description, this.compartmentId, this.shapeName, this.webAppUrl, this.connectorUrl, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleSubState, this.stateMessage, this.freeformTags, this.definedTags, this.isRoleBasedAccess, this.identityDomain, this.identityAppGuid, this.identityAppConsoleUrl, this.importedPackageNames, this.importedPackageIds, this.attachmentTypes, this.attachmentIds, this.restrictedOperations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OdaInstance model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("webAppUrl")) {
                this.webAppUrl(model.getWebAppUrl());
            }
            if (model.wasPropertyExplicitlySet("connectorUrl")) {
                this.connectorUrl(model.getConnectorUrl());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleSubState")) {
                this.lifecycleSubState(model.getLifecycleSubState());
            }
            if (model.wasPropertyExplicitlySet("stateMessage")) {
                this.stateMessage(model.getStateMessage());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("isRoleBasedAccess")) {
                this.isRoleBasedAccess(model.getIsRoleBasedAccess());
            }
            if (model.wasPropertyExplicitlySet("identityDomain")) {
                this.identityDomain(model.getIdentityDomain());
            }
            if (model.wasPropertyExplicitlySet("identityAppGuid")) {
                this.identityAppGuid(model.getIdentityAppGuid());
            }
            if (model.wasPropertyExplicitlySet("identityAppConsoleUrl")) {
                this.identityAppConsoleUrl(model.getIdentityAppConsoleUrl());
            }
            if (model.wasPropertyExplicitlySet("importedPackageNames")) {
                this.importedPackageNames(model.getImportedPackageNames());
            }
            if (model.wasPropertyExplicitlySet("importedPackageIds")) {
                this.importedPackageIds(model.getImportedPackageIds());
            }
            if (model.wasPropertyExplicitlySet("attachmentTypes")) {
                this.attachmentTypes(model.getAttachmentTypes());
            }
            if (model.wasPropertyExplicitlySet("attachmentIds")) {
                this.attachmentIds(model.getAttachmentIds());
            }
            if (model.wasPropertyExplicitlySet("restrictedOperations")) {
                this.restrictedOperations(model.getRestrictedOperations());
            }
            return this;
        }
    }
}

