/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.oda.model.OdaInstanceAttachmentOwner;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateOdaInstanceAttachmentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="attachToId")
    private final String attachToId;
    @JsonProperty(value="attachmentType")
    private final AttachmentType attachmentType;
    @JsonProperty(value="attachmentMetadata")
    private final String attachmentMetadata;
    @JsonProperty(value="restrictedOperations")
    private final List<String> restrictedOperations;
    @JsonProperty(value="owner")
    private final OdaInstanceAttachmentOwner owner;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"attachToId", "attachmentType", "attachmentMetadata", "restrictedOperations", "owner", "freeformTags", "definedTags"})
    public CreateOdaInstanceAttachmentDetails(String attachToId, AttachmentType attachmentType, String attachmentMetadata, List<String> restrictedOperations, OdaInstanceAttachmentOwner owner, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.attachToId = attachToId;
        this.attachmentType = attachmentType;
        this.attachmentMetadata = attachmentMetadata;
        this.restrictedOperations = restrictedOperations;
        this.owner = owner;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAttachToId() {
        return this.attachToId;
    }

    public AttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public String getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public List<String> getRestrictedOperations() {
        return this.restrictedOperations;
    }

    public OdaInstanceAttachmentOwner getOwner() {
        return this.owner;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateOdaInstanceAttachmentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("attachToId=").append(String.valueOf(this.attachToId));
        sb.append(", attachmentType=").append(String.valueOf((Object)this.attachmentType));
        sb.append(", attachmentMetadata=").append(String.valueOf(this.attachmentMetadata));
        sb.append(", restrictedOperations=").append(String.valueOf(this.restrictedOperations));
        sb.append(", owner=").append(String.valueOf((Object)this.owner));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateOdaInstanceAttachmentDetails)) {
            return false;
        }
        CreateOdaInstanceAttachmentDetails other = (CreateOdaInstanceAttachmentDetails)((Object)o);
        return Objects.equals(this.attachToId, other.attachToId) && Objects.equals((Object)this.attachmentType, (Object)other.attachmentType) && Objects.equals(this.attachmentMetadata, other.attachmentMetadata) && Objects.equals(this.restrictedOperations, other.restrictedOperations) && Objects.equals((Object)this.owner, (Object)other.owner) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.attachToId == null ? 43 : this.attachToId.hashCode());
        result = result * 59 + (this.attachmentType == null ? 43 : this.attachmentType.hashCode());
        result = result * 59 + (this.attachmentMetadata == null ? 43 : this.attachmentMetadata.hashCode());
        result = result * 59 + (this.restrictedOperations == null ? 43 : this.restrictedOperations.hashCode());
        result = result * 59 + (this.owner == null ? 43 : this.owner.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AttachmentType implements BmcEnum
    {
        Fusion("FUSION");

        private final String value;
        private static Map<String, AttachmentType> map;

        private AttachmentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AttachmentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AttachmentType: " + key);
        }

        static {
            map = new HashMap<String, AttachmentType>();
            for (AttachmentType v : AttachmentType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="attachToId")
        private String attachToId;
        @JsonProperty(value="attachmentType")
        private AttachmentType attachmentType;
        @JsonProperty(value="attachmentMetadata")
        private String attachmentMetadata;
        @JsonProperty(value="restrictedOperations")
        private List<String> restrictedOperations;
        @JsonProperty(value="owner")
        private OdaInstanceAttachmentOwner owner;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder attachToId(String attachToId) {
            this.attachToId = attachToId;
            this.__explicitlySet__.add("attachToId");
            return this;
        }

        public Builder attachmentType(AttachmentType attachmentType) {
            this.attachmentType = attachmentType;
            this.__explicitlySet__.add("attachmentType");
            return this;
        }

        public Builder attachmentMetadata(String attachmentMetadata) {
            this.attachmentMetadata = attachmentMetadata;
            this.__explicitlySet__.add("attachmentMetadata");
            return this;
        }

        public Builder restrictedOperations(List<String> restrictedOperations) {
            this.restrictedOperations = restrictedOperations;
            this.__explicitlySet__.add("restrictedOperations");
            return this;
        }

        public Builder owner(OdaInstanceAttachmentOwner owner) {
            this.owner = owner;
            this.__explicitlySet__.add("owner");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateOdaInstanceAttachmentDetails build() {
            CreateOdaInstanceAttachmentDetails model = new CreateOdaInstanceAttachmentDetails(this.attachToId, this.attachmentType, this.attachmentMetadata, this.restrictedOperations, this.owner, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateOdaInstanceAttachmentDetails model) {
            if (model.wasPropertyExplicitlySet("attachToId")) {
                this.attachToId(model.getAttachToId());
            }
            if (model.wasPropertyExplicitlySet("attachmentType")) {
                this.attachmentType(model.getAttachmentType());
            }
            if (model.wasPropertyExplicitlySet("attachmentMetadata")) {
                this.attachmentMetadata(model.getAttachmentMetadata());
            }
            if (model.wasPropertyExplicitlySet("restrictedOperations")) {
                this.restrictedOperations(model.getRestrictedOperations());
            }
            if (model.wasPropertyExplicitlySet("owner")) {
                this.owner(model.getOwner());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

