/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.oda.Oda;
import com.oracle.bmc.oda.model.OdaInstance;
import com.oracle.bmc.oda.model.OdaInstanceAttachment;
import com.oracle.bmc.oda.requests.GetOdaInstanceAttachmentRequest;
import com.oracle.bmc.oda.requests.GetOdaInstanceRequest;
import com.oracle.bmc.oda.requests.GetWorkRequestRequest;
import com.oracle.bmc.oda.responses.GetOdaInstanceAttachmentResponse;
import com.oracle.bmc.oda.responses.GetOdaInstanceResponse;
import com.oracle.bmc.oda.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OdaWaiters {
    private final ExecutorService executorService;
    private final Oda client;

    public OdaWaiters(ExecutorService executorService, Oda client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(GetOdaInstanceRequest request, OdaInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOdaInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(GetOdaInstanceRequest request, OdaInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOdaInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(GetOdaInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OdaInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOdaInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOdaInstanceRequest, GetOdaInstanceResponse> forOdaInstance(BmcGenericWaiter waiter, GetOdaInstanceRequest request, OdaInstance.LifecycleState ... targetStates) {
        final HashSet<OdaInstance.LifecycleState> targetStatesSet = new HashSet<OdaInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOdaInstanceRequest, GetOdaInstanceResponse>(){

            @Override
            public GetOdaInstanceResponse apply(GetOdaInstanceRequest request) {
                return OdaWaiters.this.client.getOdaInstance(request);
            }
        }, (Predicate)new Predicate<GetOdaInstanceResponse>(){

            @Override
            public boolean test(GetOdaInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getOdaInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OdaInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetOdaInstanceAttachmentRequest, GetOdaInstanceAttachmentResponse> forOdaInstanceAttachment(GetOdaInstanceAttachmentRequest request, OdaInstanceAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOdaInstanceAttachment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOdaInstanceAttachmentRequest, GetOdaInstanceAttachmentResponse> forOdaInstanceAttachment(GetOdaInstanceAttachmentRequest request, OdaInstanceAttachment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOdaInstanceAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOdaInstanceAttachmentRequest, GetOdaInstanceAttachmentResponse> forOdaInstanceAttachment(GetOdaInstanceAttachmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OdaInstanceAttachment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOdaInstanceAttachment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOdaInstanceAttachmentRequest, GetOdaInstanceAttachmentResponse> forOdaInstanceAttachment(BmcGenericWaiter waiter, GetOdaInstanceAttachmentRequest request, OdaInstanceAttachment.LifecycleState ... targetStates) {
        final HashSet<OdaInstanceAttachment.LifecycleState> targetStatesSet = new HashSet<OdaInstanceAttachment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOdaInstanceAttachmentRequest, GetOdaInstanceAttachmentResponse>(){

            @Override
            public GetOdaInstanceAttachmentResponse apply(GetOdaInstanceAttachmentRequest request) {
                return OdaWaiters.this.client.getOdaInstanceAttachment(request);
            }
        }, (Predicate)new Predicate<GetOdaInstanceAttachmentResponse>(){

            @Override
            public boolean test(GetOdaInstanceAttachmentResponse response) {
                return targetStatesSet.contains((Object)response.getOdaInstanceAttachment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return OdaWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

