/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.oda.Oda;
import com.oracle.bmc.oda.model.OdaInstanceAttachmentSummary;
import com.oracle.bmc.oda.model.OdaInstanceSummary;
import com.oracle.bmc.oda.model.WorkRequestError;
import com.oracle.bmc.oda.model.WorkRequestLogEntry;
import com.oracle.bmc.oda.model.WorkRequestSummary;
import com.oracle.bmc.oda.requests.ListOdaInstanceAttachmentsRequest;
import com.oracle.bmc.oda.requests.ListOdaInstancesRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.oda.requests.ListWorkRequestsRequest;
import com.oracle.bmc.oda.responses.ListOdaInstanceAttachmentsResponse;
import com.oracle.bmc.oda.responses.ListOdaInstancesResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.oda.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OdaPaginators {
    private final Oda client;

    public OdaPaginators(Oda client) {
        this.client = client;
    }

    public Iterable<ListOdaInstanceAttachmentsResponse> listOdaInstanceAttachmentsResponseIterator(final ListOdaInstanceAttachmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOdaInstanceAttachmentsRequest.Builder>(){

            @Override
            public ListOdaInstanceAttachmentsRequest.Builder get() {
                return ListOdaInstanceAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOdaInstanceAttachmentsResponse, String>(){

            @Override
            public String apply(ListOdaInstanceAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOdaInstanceAttachmentsRequest.Builder>, ListOdaInstanceAttachmentsRequest>(){

            @Override
            public ListOdaInstanceAttachmentsRequest apply(RequestBuilderAndToken<ListOdaInstanceAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOdaInstanceAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOdaInstanceAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOdaInstanceAttachmentsRequest, ListOdaInstanceAttachmentsResponse>(){

            @Override
            public ListOdaInstanceAttachmentsResponse apply(ListOdaInstanceAttachmentsRequest request) {
                return OdaPaginators.this.client.listOdaInstanceAttachments(request);
            }
        });
    }

    public Iterable<OdaInstanceAttachmentSummary> listOdaInstanceAttachmentsRecordIterator(final ListOdaInstanceAttachmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOdaInstanceAttachmentsRequest.Builder>(){

            @Override
            public ListOdaInstanceAttachmentsRequest.Builder get() {
                return ListOdaInstanceAttachmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOdaInstanceAttachmentsResponse, String>(){

            @Override
            public String apply(ListOdaInstanceAttachmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOdaInstanceAttachmentsRequest.Builder>, ListOdaInstanceAttachmentsRequest>(){

            @Override
            public ListOdaInstanceAttachmentsRequest apply(RequestBuilderAndToken<ListOdaInstanceAttachmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOdaInstanceAttachmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOdaInstanceAttachmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOdaInstanceAttachmentsRequest, ListOdaInstanceAttachmentsResponse>(){

            @Override
            public ListOdaInstanceAttachmentsResponse apply(ListOdaInstanceAttachmentsRequest request) {
                return OdaPaginators.this.client.listOdaInstanceAttachments(request);
            }
        }, (Function)new Function<ListOdaInstanceAttachmentsResponse, List<OdaInstanceAttachmentSummary>>(){

            @Override
            public List<OdaInstanceAttachmentSummary> apply(ListOdaInstanceAttachmentsResponse response) {
                return response.getOdaInstanceAttachmentCollection().getItems();
            }
        });
    }

    public Iterable<ListOdaInstancesResponse> listOdaInstancesResponseIterator(final ListOdaInstancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOdaInstancesRequest.Builder>(){

            @Override
            public ListOdaInstancesRequest.Builder get() {
                return ListOdaInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOdaInstancesResponse, String>(){

            @Override
            public String apply(ListOdaInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOdaInstancesRequest.Builder>, ListOdaInstancesRequest>(){

            @Override
            public ListOdaInstancesRequest apply(RequestBuilderAndToken<ListOdaInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOdaInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOdaInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOdaInstancesRequest, ListOdaInstancesResponse>(){

            @Override
            public ListOdaInstancesResponse apply(ListOdaInstancesRequest request) {
                return OdaPaginators.this.client.listOdaInstances(request);
            }
        });
    }

    public Iterable<OdaInstanceSummary> listOdaInstancesRecordIterator(final ListOdaInstancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOdaInstancesRequest.Builder>(){

            @Override
            public ListOdaInstancesRequest.Builder get() {
                return ListOdaInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOdaInstancesResponse, String>(){

            @Override
            public String apply(ListOdaInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOdaInstancesRequest.Builder>, ListOdaInstancesRequest>(){

            @Override
            public ListOdaInstancesRequest apply(RequestBuilderAndToken<ListOdaInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOdaInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOdaInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOdaInstancesRequest, ListOdaInstancesResponse>(){

            @Override
            public ListOdaInstancesResponse apply(ListOdaInstancesRequest request) {
                return OdaPaginators.this.client.listOdaInstances(request);
            }
        }, (Function)new Function<ListOdaInstancesResponse, List<OdaInstanceSummary>>(){

            @Override
            public List<OdaInstanceSummary> apply(ListOdaInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OdaPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return OdaPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OdaPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return OdaPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OdaPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return OdaPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }
}

