/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda;

import com.oracle.bmc.oda.Management;
import com.oracle.bmc.oda.model.LifecycleState;
import com.oracle.bmc.oda.requests.GetAuthenticationProviderRequest;
import com.oracle.bmc.oda.requests.GetChannelRequest;
import com.oracle.bmc.oda.requests.GetDigitalAssistantParameterRequest;
import com.oracle.bmc.oda.requests.GetDigitalAssistantRequest;
import com.oracle.bmc.oda.requests.GetSkillParameterRequest;
import com.oracle.bmc.oda.requests.GetSkillRequest;
import com.oracle.bmc.oda.requests.GetTranslatorRequest;
import com.oracle.bmc.oda.responses.GetAuthenticationProviderResponse;
import com.oracle.bmc.oda.responses.GetChannelResponse;
import com.oracle.bmc.oda.responses.GetDigitalAssistantParameterResponse;
import com.oracle.bmc.oda.responses.GetDigitalAssistantResponse;
import com.oracle.bmc.oda.responses.GetSkillParameterResponse;
import com.oracle.bmc.oda.responses.GetSkillResponse;
import com.oracle.bmc.oda.responses.GetTranslatorResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ManagementWaiters {
    private final ExecutorService executorService;
    private final Management client;

    public ManagementWaiters(ExecutorService executorService, Management client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAuthenticationProviderRequest, GetAuthenticationProviderResponse> forAuthenticationProvider(GetAuthenticationProviderRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuthenticationProvider(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAuthenticationProviderRequest, GetAuthenticationProviderResponse> forAuthenticationProvider(GetAuthenticationProviderRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAuthenticationProvider(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAuthenticationProviderRequest, GetAuthenticationProviderResponse> forAuthenticationProvider(GetAuthenticationProviderRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAuthenticationProvider(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAuthenticationProviderRequest, GetAuthenticationProviderResponse> forAuthenticationProvider(BmcGenericWaiter waiter, GetAuthenticationProviderRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAuthenticationProviderRequest, GetAuthenticationProviderResponse>(){

            @Override
            public GetAuthenticationProviderResponse apply(GetAuthenticationProviderRequest request) {
                return ManagementWaiters.this.client.getAuthenticationProvider(request);
            }
        }, (Predicate)new Predicate<GetAuthenticationProviderResponse>(){

            @Override
            public boolean test(GetAuthenticationProviderResponse response) {
                return targetStatesSet.contains((Object)response.getAuthenticationProvider().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetChannelRequest, GetChannelResponse> forChannel(GetChannelRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forChannel(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetChannelRequest, GetChannelResponse> forChannel(GetChannelRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forChannel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetChannelRequest, GetChannelResponse> forChannel(GetChannelRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forChannel(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetChannelRequest, GetChannelResponse> forChannel(BmcGenericWaiter waiter, GetChannelRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetChannelRequest, GetChannelResponse>(){

            @Override
            public GetChannelResponse apply(GetChannelRequest request) {
                return ManagementWaiters.this.client.getChannel(request);
            }
        }, (Predicate)new Predicate<GetChannelResponse>(){

            @Override
            public boolean test(GetChannelResponse response) {
                return targetStatesSet.contains((Object)response.getChannel().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse> forDigitalAssistant(GetDigitalAssistantRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDigitalAssistant(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse> forDigitalAssistant(GetDigitalAssistantRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDigitalAssistant(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse> forDigitalAssistant(GetDigitalAssistantRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDigitalAssistant(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDigitalAssistantRequest, GetDigitalAssistantResponse> forDigitalAssistant(BmcGenericWaiter waiter, GetDigitalAssistantRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDigitalAssistantRequest, GetDigitalAssistantResponse>(){

            @Override
            public GetDigitalAssistantResponse apply(GetDigitalAssistantRequest request) {
                return ManagementWaiters.this.client.getDigitalAssistant(request);
            }
        }, (Predicate)new Predicate<GetDigitalAssistantResponse>(){

            @Override
            public boolean test(GetDigitalAssistantResponse response) {
                return targetStatesSet.contains((Object)response.getDigitalAssistant().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse> forDigitalAssistantParameter(GetDigitalAssistantParameterRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDigitalAssistantParameter(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse> forDigitalAssistantParameter(GetDigitalAssistantParameterRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDigitalAssistantParameter(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse> forDigitalAssistantParameter(GetDigitalAssistantParameterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDigitalAssistantParameter(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse> forDigitalAssistantParameter(BmcGenericWaiter waiter, GetDigitalAssistantParameterRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDigitalAssistantParameterRequest, GetDigitalAssistantParameterResponse>(){

            @Override
            public GetDigitalAssistantParameterResponse apply(GetDigitalAssistantParameterRequest request) {
                return ManagementWaiters.this.client.getDigitalAssistantParameter(request);
            }
        }, (Predicate)new Predicate<GetDigitalAssistantParameterResponse>(){

            @Override
            public boolean test(GetDigitalAssistantParameterResponse response) {
                return targetStatesSet.contains((Object)response.getDigitalAssistantParameter().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSkillRequest, GetSkillResponse> forSkill(GetSkillRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSkill(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSkillRequest, GetSkillResponse> forSkill(GetSkillRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSkill(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSkillRequest, GetSkillResponse> forSkill(GetSkillRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSkill(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSkillRequest, GetSkillResponse> forSkill(BmcGenericWaiter waiter, GetSkillRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSkillRequest, GetSkillResponse>(){

            @Override
            public GetSkillResponse apply(GetSkillRequest request) {
                return ManagementWaiters.this.client.getSkill(request);
            }
        }, (Predicate)new Predicate<GetSkillResponse>(){

            @Override
            public boolean test(GetSkillResponse response) {
                return targetStatesSet.contains((Object)response.getSkill().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetSkillParameterRequest, GetSkillParameterResponse> forSkillParameter(GetSkillParameterRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSkillParameter(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetSkillParameterRequest, GetSkillParameterResponse> forSkillParameter(GetSkillParameterRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forSkillParameter(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetSkillParameterRequest, GetSkillParameterResponse> forSkillParameter(GetSkillParameterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forSkillParameter(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetSkillParameterRequest, GetSkillParameterResponse> forSkillParameter(BmcGenericWaiter waiter, GetSkillParameterRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetSkillParameterRequest, GetSkillParameterResponse>(){

            @Override
            public GetSkillParameterResponse apply(GetSkillParameterRequest request) {
                return ManagementWaiters.this.client.getSkillParameter(request);
            }
        }, (Predicate)new Predicate<GetSkillParameterResponse>(){

            @Override
            public boolean test(GetSkillParameterResponse response) {
                return targetStatesSet.contains((Object)response.getSkillParameter().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(GetTranslatorRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTranslator(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(GetTranslatorRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTranslator(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(GetTranslatorRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTranslator(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTranslatorRequest, GetTranslatorResponse> forTranslator(BmcGenericWaiter waiter, GetTranslatorRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTranslatorRequest, GetTranslatorResponse>(){

            @Override
            public GetTranslatorResponse apply(GetTranslatorRequest request) {
                return ManagementWaiters.this.client.getTranslator(request);
            }
        }, (Predicate)new Predicate<GetTranslatorResponse>(){

            @Override
            public boolean test(GetTranslatorResponse response) {
                return targetStatesSet.contains((Object)response.getTranslator().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }
}

