/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ocvp.EsxiHost;
import com.oracle.bmc.ocvp.model.LifecycleStates;
import com.oracle.bmc.ocvp.requests.GetEsxiHostRequest;
import com.oracle.bmc.ocvp.responses.GetEsxiHostResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class EsxiHostWaiters {
    private final ExecutorService executorService;
    private final EsxiHost client;

    public EsxiHostWaiters(ExecutorService executorService, EsxiHost client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetEsxiHostRequest, GetEsxiHostResponse> forEsxiHost(GetEsxiHostRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEsxiHost(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetEsxiHostRequest, GetEsxiHostResponse> forEsxiHost(GetEsxiHostRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forEsxiHost(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetEsxiHostRequest, GetEsxiHostResponse> forEsxiHost(GetEsxiHostRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forEsxiHost(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetEsxiHostRequest, GetEsxiHostResponse> forEsxiHost(BmcGenericWaiter waiter, GetEsxiHostRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetEsxiHostRequest, GetEsxiHostResponse>(){

            @Override
            public GetEsxiHostResponse apply(GetEsxiHostRequest request) {
                return EsxiHostWaiters.this.client.getEsxiHost(request);
            }
        }, (Predicate)new Predicate<GetEsxiHostResponse>(){

            @Override
            public boolean test(GetEsxiHostResponse response) {
                return targetStatesSet.contains((Object)response.getEsxiHost().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }
}

