/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ocvp;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.ocvp.EsxiHost;
import com.oracle.bmc.ocvp.EsxiHostAsyncClient;
import com.oracle.bmc.ocvp.EsxiHostPaginators;
import com.oracle.bmc.ocvp.EsxiHostWaiters;
import com.oracle.bmc.ocvp.model.EsxiHostCollection;
import com.oracle.bmc.ocvp.requests.CreateEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.DeleteEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.GetEsxiHostRequest;
import com.oracle.bmc.ocvp.requests.ListEsxiHostsRequest;
import com.oracle.bmc.ocvp.requests.UpdateEsxiHostRequest;
import com.oracle.bmc.ocvp.responses.CreateEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.DeleteEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.GetEsxiHostResponse;
import com.oracle.bmc.ocvp.responses.ListEsxiHostsResponse;
import com.oracle.bmc.ocvp.responses.UpdateEsxiHostResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsxiHostClient
extends BaseSyncClient
implements EsxiHost {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ESXIHOST").serviceEndpointPrefix("").serviceEndpointTemplate("https://ocvps.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EsxiHostAsyncClient.class);
    private final EsxiHostWaiters waiters;
    private final EsxiHostPaginators paginators;

    private EsxiHostClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("EsxiHost-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new EsxiHostWaiters(executorService, this);
        this.paginators = new EsxiHostPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateEsxiHostResponse createEsxiHost(CreateEsxiHostRequest request) {
        Objects.requireNonNull(request.getCreateEsxiHostDetails(), "createEsxiHostDetails is required");
        return (CreateEsxiHostResponse)this.clientCall(request, CreateEsxiHostResponse::builder).logger(LOG, "createEsxiHost").serviceDetails("EsxiHost", "CreateEsxiHost", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost").method(Method.POST).requestBuilder(CreateEsxiHostRequest::builder).basePath("/20200501").appendPathParam("esxiHosts").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateEsxiHostResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateEsxiHostResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteEsxiHostResponse deleteEsxiHost(DeleteEsxiHostRequest request) {
        Validate.notBlank((String)request.getEsxiHostId(), (String)"esxiHostId must not be blank", (Object[])new Object[0]);
        return (DeleteEsxiHostResponse)this.clientCall(request, DeleteEsxiHostResponse::builder).logger(LOG, "deleteEsxiHost").serviceDetails("EsxiHost", "DeleteEsxiHost", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/DeleteEsxiHost").method(Method.DELETE).requestBuilder(DeleteEsxiHostRequest::builder).basePath("/20200501").appendPathParam("esxiHosts").appendPathParam(request.getEsxiHostId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteEsxiHostResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEsxiHostResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetEsxiHostResponse getEsxiHost(GetEsxiHostRequest request) {
        Validate.notBlank((String)request.getEsxiHostId(), (String)"esxiHostId must not be blank", (Object[])new Object[0]);
        return (GetEsxiHostResponse)this.clientCall(request, GetEsxiHostResponse::builder).logger(LOG, "getEsxiHost").serviceDetails("EsxiHost", "GetEsxiHost", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/GetEsxiHost").method(Method.GET).requestBuilder(GetEsxiHostRequest::builder).basePath("/20200501").appendPathParam("esxiHosts").appendPathParam(request.getEsxiHostId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.ocvp.model.EsxiHost.class, GetEsxiHostResponse.Builder::esxiHost).handleResponseHeaderString("etag", GetEsxiHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEsxiHostResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListEsxiHostsResponse listEsxiHosts(ListEsxiHostsRequest request) {
        return (ListEsxiHostsResponse)this.clientCall(request, ListEsxiHostsResponse::builder).logger(LOG, "listEsxiHosts").serviceDetails("EsxiHost", "ListEsxiHosts", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHostSummary/ListEsxiHosts").method(Method.GET).requestBuilder(ListEsxiHostsRequest::builder).basePath("/20200501").appendPathParam("esxiHosts").appendQueryParam("sddcId", (Object)request.getSddcId()).appendQueryParam("computeInstanceId", (Object)request.getComputeInstanceId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EsxiHostCollection.class, ListEsxiHostsResponse.Builder::esxiHostCollection).handleResponseHeaderString("opc-request-id", ListEsxiHostsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEsxiHostsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public UpdateEsxiHostResponse updateEsxiHost(UpdateEsxiHostRequest request) {
        Validate.notBlank((String)request.getEsxiHostId(), (String)"esxiHostId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEsxiHostDetails(), "updateEsxiHostDetails is required");
        return (UpdateEsxiHostResponse)this.clientCall(request, UpdateEsxiHostResponse::builder).logger(LOG, "updateEsxiHost").serviceDetails("EsxiHost", "UpdateEsxiHost", "https://docs.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/UpdateEsxiHost").method(Method.PUT).requestBuilder(UpdateEsxiHostRequest::builder).basePath("/20200501").appendPathParam("esxiHosts").appendPathParam(request.getEsxiHostId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(com.oracle.bmc.ocvp.model.EsxiHost.class, UpdateEsxiHostResponse.Builder::esxiHost).handleResponseHeaderString("etag", UpdateEsxiHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEsxiHostResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public EsxiHostWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public EsxiHostPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public EsxiHostClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EsxiHostClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EsxiHostClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EsxiHostClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EsxiHostClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EsxiHostClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EsxiHostClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EsxiHostClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EsxiHostClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EsxiHostClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EsxiHostClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EsxiHostClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EsxiHostClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EsxiHostClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EsxiHostClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EsxiHostClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EsxiHostClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public EsxiHostClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EsxiHostClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

